/*
 * PageImpl.cpp
 *
 *  Created on: 02.03.2012
 *      Author: Stoycho Stefanov
 */

#include "PageImpl.h"
#include "PanelPage.h"
#include "Defs.h"
#include <Wt/WColor>
#include <Wt/WIntValidator>
#include <Wt/WPopupMenu>
#include <Wt/WPopupMenuItem>
#include <boost/thread.hpp>
#include <iostream>
using namespace Wt;
using namespace std;
PageImpl::PageImpl(PanelPage* parent)
:
	editColor_(176, 196, 222),// LightSteelBlue
	measureColor_(60, 179, 113), // MediumSeeGreen
	bgResourceEdit_(0),
    bgResourceEditGrid_(0), // repaint at grid size change
    bgResourceMeasure_(0),
	gridStyle_(Defs::Dots),
	gridSize_(10),
	gridMarkerSize_(1),
    gridSizeValidator_(new WIntValidator(parent)),
    gridMarkerSizeValidator_(new WIntValidator(parent)),
    showGrid_(false),
	snapToGrid_(false),
	showButtonBar_(true),
	heightPage_(-1),
	widthPage_(-1)
{
    cout << MSGAT << "" << endl;
	gridMarkerSizeValidator_->setMandatory(true);
	gridMarkerSizeValidator_->setBottom(1);
	gridSizeValidator_->setMandatory(true);
	gridSizeValidator_->setBottom(gridMarkerSize_+1);
}

PageImpl::~PageImpl() {
	#ifdef _DEBUG
	std::cout << MSGAT << "destructor end" << std::endl;
	#endif
}
