/*
 * PageImpl.h
 *
 *  Created on: 02.03.2012
 *      Author: Stoycho Stefanov
 */

#ifndef IMCPAGEIMPL_H_
#define IMCPAGEIMPL_H_

#include "Defs.h"
#include <boost/smart_ptr.hpp>
#include <boost/signals.hpp>
#include <Wt/WColor>
#include <Wt/WResource>
#include <Wt/WIntValidator>
#include <set>


class PanelPage;
class Widget;

class PageImpl
{
public:
	~PageImpl();
private:
	PageImpl(PanelPage*);

	Wt::WColor editColor_;
	Wt::WColor measureColor_;
	boost::scoped_ptr<Wt::WResource> bgResourceEdit_;
	boost::scoped_ptr<Wt::WResource> bgResourceEditGrid_; // repaint at grid size change
	boost::scoped_ptr<Wt::WResource> bgResourceMeasure_;

	Defs::GridStyle gridStyle_;
	int gridSize_;
	int gridMarkerSize_;
	Wt::WIntValidator* gridSizeValidator_; 	// int >= 2*gridMarkerSize
	Wt::WIntValidator* gridMarkerSizeValidator_; 	// int >= 1
	bool showGrid_;
	bool snapToGrid_;
	bool showButtonBar_;

	int heightPage_; //&&
	int widthPage_;
	std::set<Widget*> selectedChildren_;
friend class PanelPage;
};

#endif /* IMCPAGEIMPL_H_ */
