/*
 * PanelPage.cpp
 *
 *  Created on: 05.12.2011
 *      Author: Stoycho Stefanov
 */

#include "Defs.h"

#include "Widget.h"
#include "PanelPage.h"
#include "PropertiesContainer.h"
#include "WShape.h"

#include <Wt/WContainerWidget>
#include <Wt/WWebWidget>
#include <Wt/WCompositeWidget>
#include <Wt/WDialog>
#include <Wt/WString>
#include <Wt/WTimer>
#include <Wt/WSvgImage>
#include <Wt/WPainter>
#include <Wt/WColor>
#include <Wt/WPanel>
#include <Wt/WText>
#include <Wt/WLineEdit>
#include <Wt/WInPlaceEdit>
#include <Wt/WCheckBox>
#include <Wt/WComboBox>

#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <time.h>

#include <boost/filesystem.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/foreach.hpp>
#include <boost/bind.hpp>

#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/smart_ptr.hpp>

#include <openssl/evp.h>

using namespace Wt;
using namespace std;
using namespace boost::property_tree;

PanelPage::PanelPage(WContainerWidget* parent)
:
	Container(parent),
    mouseWentDown_(true),
    impl_(new PageImpl(this)),
    popup_(0),
    onPopupHide_()
{
	setAttributeValue("oncontextmenu","event.cancelBubble = true; event.returnValue = false; return false;");
	this->setPositionScheme(Relative);
	onMouseDown_ = this->mouseWentDown().connect(this, &PanelPage::onMouseDown);
	onMouseUp_ = this->mouseWentUp().connect(this, &PanelPage::onMouseUp);
	onDoubleClicked_ = this->doubleClicked().connect(this, &PanelPage::onDoubleClick);
}

void PanelPage::blockEvents(bool b ){
    cout << MSGAT << "block = "<< ((b)?"true":"false") << endl;
    onMouseDown_.block(b);
    onMouseUp_.block(b);
    onDoubleClicked_.block(b);
}

void PanelPage::onMouseUp(const Wt::WMouseEvent &e) {
    cout << MSGAT << "mouse UP" << endl;
    switch (e.button()) {
        case  WMouseEvent::RightButton :
            if (mouseWentDown_) {
                showPopup(e);
            }
            break;
        default: break;
    }
}

void PanelPage::onMouseDown(const Wt::WMouseEvent &e) {
    cout << MSGAT << "mouse DOWN" << endl;
    mouseWentDown_ = not Widget::mouseWentDown_;
    switch (e.button()) {
        case  WMouseEvent::LeftButton :
            if(mouseWentDown_) {
                selectAll(false);
            }
            break;
        case  WMouseEvent::RightButton :
            break;
        default:
            break;
    }
}

void PanelPage::onDoubleClick(const Wt::WMouseEvent &e) {
    cout << MSGAT << "mouseWentDown_ = " << ((mouseWentDown_)?"true":"false") << endl;
    cout << MSGAT << "Widget::mouseWentDown_ = " << ((Widget::mouseWentDown_)?"true":"false") << endl;
    propertiesPopup();
}

void PanelPage::showPopup(const WMouseEvent &e) {

	if (!popup_) {
		popup_.reset(new WPopupMenu());
		popup_->setAttributeValue("oncontextmenu","event.cancelBubble = true; event.returnValue = false; return false;");
		popup_->addItem("widget");
		popup_->addItem("properties");
	}

	if(popup_->isHidden()){
		popup_->popup(e);
		popup_->refresh();
		onPopupHide_.disconnect();
		// (re)connect in order to use the actual mouse event coordinates
		onPopupHide_ = popup_->aboutToHide().connect(boost::bind(&PanelPage::popupAction,this,e));
	}
	else {
		popup_->hide();
	}
}

void PanelPage::popupAction(const Wt::WMouseEvent& e) {
	if (popup_->result() == 0) {
		return; // any Item was selected
	}
	else if (popup_->result()->text() == WString("properties")) {
		this->propertiesPopup();
	}
	else if (popup_->result()->text() == WString("widget")) {
        WShape *widget = new WShape(this);
        widget->setShape(Defs::Elipse);
        widget->setOffsets(e.widget().x,Left);
        widget->setOffsets(e.widget().y,Top);
        this->addWidget(widget);
    }
	else { // unknown menu item
		cout << "Debug msg: " << MSGAT << "ASSERT: unknown menu item" << endl;
		cout << "Debug msg: " << MSGAT << "item's text: "    << popup_->result()->text() << endl;
		cout << "Debug msg: " << MSGAT << "item's text key: "<< popup_->result()->text().key() << endl;
	}
	refresh();
}

void PanelPage::refresh(){
    cout << MSGAT << "" << endl;
    WWebWidget::refresh();
}

std::vector< std::vector<Wt::WWidget* > >PanelPage::getProperties(Defs::PropertiesGroup propGr) {
	std::vector<Wt::WWidget* >  vw; // vector of widgets
	std::vector<std::vector<Wt::WWidget* > > vvw; // vector of vector of widgets
	switch (propGr)	{
		case Defs::General : {
			vw.push_back(new Wt::WText(WString::tr("name")+ ":"));
			vw.push_back(new Wt::WText("Panel Page"));
			vvw.push_back(vw);
			break;
		}
	}
return vvw;
}

void PanelPage::selectAll(bool b) {

	if (b) {
		BOOST_FOREACH(WWidget* child,this->children()) {
			if (Widget* widget = dynamic_cast<Widget*> (child)) {
				widget->select(b);
			}
		}
	}
	else {
		BOOST_FOREACH(Widget* widget, selected()) {
			widget->select(b);
		}
	}
}
