/*
 * PanelPage.h
 *
 *  Created on: 05.12.2011
 *      Author: Stoycho Stefanov
 */

#ifndef IMCPANELPAGE_H_
#define IMCPANELPAGE_H_

#include "Defs.h"
#include "PageImpl.h"

#include <boost/property_tree/ptree.hpp>
#include <boost/filesystem.hpp>
#include <boost/smart_ptr.hpp>
#include <boost/signals.hpp>

#include "Container.h"
#include <Wt/WPopupMenu>
#include <Wt/WPopupMenuItem>
#include <Wt/WString>

namespace Wt{
class WColor;
class WResource;
class WCheckBox;
class WIntValidator;
class WComboBox;
}

class PanelPage: public Container
{
public:
	PanelPage(WContainerWidget* parent = 0);
	virtual ~PanelPage(){};
	std::vector< std::vector<Wt::WWidget* > >getProperties(Defs::PropertiesGroup propGr);
    void clear(){WContainerWidget::clear(); impl_->selectedChildren_.clear();};

    void refresh();
    void selectAll(bool b);
    std::set<Widget*>& selected(){return impl_->selectedChildren_;};


    void blockEvents(bool b = true);

    bool mouseWentDown_;
protected:
//    WContainerWidget* getPropertiesDialog(void);
private:
	void setProperty(const boost::property_tree::ptree&);
	void onMouseUp(const Wt::WMouseEvent &);
	void onMouseDown(const Wt::WMouseEvent &);
	void onDoubleClick(const Wt::WMouseEvent &);
	void showPopup(const Wt::WMouseEvent&);
	void popupAction(const Wt::WMouseEvent&);
	boost::scoped_ptr<PageImpl> 	impl_;
	boost::scoped_ptr<Wt::WPopupMenu> popup_;

	boost::signals::connection onPopupHide_;
	boost::signals::connection onMouseUp_;
	boost::signals::connection onMouseDown_;
	boost::signals::connection onDoubleClicked_;

friend class PageImpl;
};

#endif /* IMCPANELPAGE_H_ */
