/*
 * PropertiesContainer.cpp
 *
 *  Created on: 19.10.2011
 *      Author: Stoycho Stefanov
 */

#include "Defs.h"
#include "PropertiesContainer.h"
#include <Wt/WContainerWidget>
#include <Wt/WCompositeWidget>
#include <Wt/WWebWidget>
#include <Wt/WBoxLayout>
#include <Wt/WBreak>
#include <Wt/WTable>
#include <vector>
#include <boost/foreach.hpp>

#include <iostream>
using namespace std;
using namespace Wt;


PropertiesContainer::PropertiesContainer() {
	Wt::WBoxLayout *layout= new Wt::WBoxLayout(Wt::WBoxLayout::TopToBottom);
	this->setLayout(layout, Wt::AlignTop | Wt::AlignLeft);
	layout->setSpacing(3);
}

PropertiesContainer::~PropertiesContainer() {
}

void PropertiesContainer::addProperties(const std::vector<std::vector<WWidget*> >& propv) {
	WTable *table = new WTable();
	this->layout()->addWidget(table);
	int row(0),column(0);
	for (std::vector<std::vector<WWidget*> >::const_iterator iter = propv.begin(); iter!=propv.end(); ++iter) {
		++row;
		column = 0;
		for (std::vector<WWidget*>::const_iterator witer = iter->begin(); witer!=iter->end(); ++witer) {
			++column;
			table->elementAt(row,column)->addWidget(*witer);
		}
	}
}
