/*
 * Shape.cpp
 *
 *  Created on: 25.06.2012
 *      Author: Stoycho Stefanov
 */

#include "Shape.h"
#include "WShape.h"
#include <Wt/WPainter>
#include <Wt/WPen>
#include <Wt/WBrush>
#include <Wt/WColor>

using namespace Wt;
using namespace Defs;

Shape::Shape(WShape* parent)
:
	WPaintedWidget(parent),
	parent_(parent),
	shape_(Rectangle),
	lineType_(Raising), // used only for Line shape
	lineWidth_(1),
	lineColor_(black),
	bgColor_(transparent)
{
	resize(parent->width().value(),parent->height().value());
	setPositionScheme(Absolute);
}

Shape::~Shape() {
}

void Shape::paintEvent(Wt::WPaintDevice *paintDevice) {
	Wt::WPainter painter(paintDevice);
	WPen pen(lineColor_);
	WBrush brush(bgColor_);

	painter.setBrush(brush);
	pen.setWidth(lineWidth_);
	painter.setPen(pen);
	parent_->setMinimumSize(20,20);
	switch ( shape_ ) {
		case Circle: {
			double d = min(parent()->width().value(),parent()->height().value());
			painter.drawEllipse(0,0,d,d);
			break;
		}
		case Elipse:
			painter.drawEllipse(0,0,parent()->width().value(),parent()->height().value());
			break;
		case Square:
		case Rectangle:
			pen.setWidth(2*lineWidth_);
			painter.setPen(pen);
			painter.drawRect(0,0,parent()->width().value(),parent()->height().value());
			break;
		case RoundedSquare:{
		}
		case RoundedRectangle:{
			double arcRadius = 15.0;
			double shift = arcRadius + static_cast<double>(lineWidth_)/2;
			Wt::WPainterPath path(Wt::WPointF(shift, shift-arcRadius));
			path.arcTo(shift,shift,arcRadius,90,90);
			path.arcTo(shift, parent()->height().value()-(shift),arcRadius,180,90);
			path.arcTo(parent()->width().value()-(shift), parent()->height().value()-(shift),arcRadius,270,90);
			path.arcTo(parent()->width().value()-(shift), shift,arcRadius,0,90);
			path.closeSubPath();
			painter.drawPath(path);
			parent_->setMinimumSize(2*(shift),2*(shift));
			break;
		}
		case Line: {
			parent_->setMinimumSize(lineWidth_,lineWidth_);
			double shift = static_cast<double>(lineWidth_) /2;
			if ( lineType_ == Raising ) {
				painter.drawLine(parent_->width().value()-shift, shift, shift, parent_->height().value()-shift);
			}
			else { // Falling
				painter.drawLine(shift,shift,parent_->width().value()-shift,parent_->height().value()-shift);
			}
			// reset handles
			break;
		}
		default:
			break;
	}
}
