/*
 * WShape.cpp
 *
 *  Created on: 25.06.2012
 *      Author: Stoycho Stefanov
 */


#include "WShape.h"
#include "Shape.h"
#include <Wt/WWidget>
#include <Wt/WLineEdit>
#include <Wt/WIntValidator>
#include <Wt/WInPlaceEdit>
#include <Wt/WColor>
#include <Wt/WCheckBox>
#include <Wt/WText>

#include <vector>
#include <boost/bind.hpp>

using namespace Wt;
using namespace std;

WShape::WShape(PanelPage *parent)
:
	Widget(parent),
	face_(new Shape(this)),
	widthValidator_(new WIntValidator(this)) 	// int >= 0 common for label and value;
{
	setPositionScheme(Absolute);

	widthValidator_->setMandatory(true);
	widthValidator_->setBottom(0);

	face_->setParentWidget(0);
	this->insertWidget(0,face_);
}

WShape::~WShape() {
}

void WShape::setShape(Defs::ShapeStyle shape){
	face_->shape_ = shape;
	if ((shape == Defs::Square) ||
		(shape == Defs::RoundedSquare) ||
		(shape == Defs::Circle)){
		resize(100,100);
	}
	else if (shape == Defs::Line){
		resize(200,face_->lineWidth_);
	}
	else {
		resize(200,100);
	}
	update();
}

void WShape::setLineType(Defs::LineType type){
	face_->lineType_ = type;
	update();
}

void WShape::update(void) {
	face_->resize(width(),height());
	face_->update();
}

std::vector< std::vector<Wt::WWidget* > > WShape::getProperties(Defs::PropertiesGroup propGr) {
	std::vector<std::vector<Wt::WWidget* > > vvw; // vector of vector of widgets
return vvw;
}

void WShape::setFrameWidth(int i) {
	if ( face_->shape_ == Defs::Line ) {
		int w = static_cast<int>(width().value());
		int h = static_cast<int>(height().value());
		resize( ((w == face_->lineWidth_) ? i : w) , ((h == face_->lineWidth_) ? i : h) );
	}
	face_->lineWidth_ = i;
	update();
};
