#include "Widget.h"

#include "Defs.h"
#include "PanelPage.h"

#include <Wt/WContainerWidget>
#include <Wt/WCssDecorationStyle>
#include <Wt/WApplication>
#include <Wt/WBorder>
#include <Wt/WEvent>
#include <Wt/WPanel>
#include <Wt/WPopupMenu>
#include <Wt/WPopupMenuItem>
#include <Wt/WDialog>
#include <Wt/WText>
#include <Wt/WLink>
#include <Wt/WPushButton>
#include <Wt/WMessageBox>
#include <Wt/WInPlaceEdit>
#include <Wt/WDoubleValidator>
#include <Wt/WLineEdit>
#include <Wt/WCheckBox>
#include <Wt/WSortFilterProxyModel>
#include <Wt/WStandardItem>
#include <Wt/WStandardItemModel>

#include <iostream>
#include <string>
#include <vector>
#include <set>
#include <boost/signals.hpp>
#include <boost/bind.hpp>
#include <boost/foreach.hpp>
#include <boost/lexical_cast.hpp>

using namespace Wt;
using namespace std;
using namespace Defs;

bool Widget::mouseWentDown_(false);
bool Widget::doubleClicked_(false);

Widget::Widget(PanelPage* parent) :
	Container(),
	parent_(parent),
	selected_(false),
	border_(WBorder::Hidden, 1, WColor(100, 100, 100))
{
	resize(100, 100);
	setAttributeValue("oncontextmenu", "event.cancelBubble = true; event.returnValue = false; return false;");
	decorationStyle().setBorder(border_);
	setPositionScheme(Absolute);
	this->mouseWentDown().connect(this, &Widget::onMouseDown);
	this->mouseWentUp().connect(this, &Widget::onMouseUp);
	this->doubleClicked().connect(this, &Widget::onDoubleClick);
}


void Widget::onDoubleClick(const Wt::WMouseEvent &e) {
    cout << endl<< MSGAT << "double click!!" << endl <<endl;
	doubleClicked_ = true;
}

void Widget::onMouseDown(const Wt::WMouseEvent &e) {
    cout << endl<< MSGAT << "onMouseDown!!" << endl <<endl;
	mouseWentDown_ = true;
}

void Widget::onMouseUp(const Wt::WMouseEvent &e) {
    cout << endl<< MSGAT << "onMouseUp!!" << endl <<endl;
	mouseWentDown_ = false;
    (selected_) ? select(false) : select();
}

void Widget::select(bool b) {
	if (not selected_ && b) {
		border_.setStyle(WBorder::Dashed);
		decorationStyle().setBorder(border_);
		setOffsets(offset(Left).value() - border_.explicitWidth().value(),
				Left);
		setOffsets(offset(Top).value() - border_.explicitWidth().value(), Top);
	} else if (selected_ && not b) {
		border_.setStyle(WBorder::Hidden);
		decorationStyle().setBorder(border_);
		setOffsets(offset(Left).value() + border_.explicitWidth().value(),
				Left);
		setOffsets(offset(Top).value() + border_.explicitWidth().value(), Top);
	}
	selected_ = b;
}

std::vector<std::vector<Wt::WWidget*> > Widget::getProperties(Defs::PropertiesGroup propGr) {
	std::vector<std::vector<Wt::WWidget*> > vvw; // vector of vector of widgets
	return vvw;
}

