/*
 * Widget.h
 *
 *  Created on: 17.10.2011
 *      Author: Stoycho Stefanov
 *
 */

#ifndef IMCWIDGET_H_
#define IMCWIDGET_H_

#include "Defs.h"
#include "Container.h"
class PanelPage;
#include <Wt/WBorder>
#include <boost/smart_ptr.hpp>
#include <boost/property_tree/ptree.hpp>

#include <iostream>
using namespace std;
class Widget: public Container {
public:
	Widget(PanelPage *parent);
	virtual ~Widget(){};
	const PanelPage* page(void) {return parent_;};
protected:
    virtual std::vector< std::vector<Wt::WWidget* > > getProperties(Defs::PropertiesGroup);
private:
    PanelPage	*parent_;
	bool selected_;
    Wt::WBorder border_;
private:
    void onMouseDown(const Wt::WMouseEvent &);
	void onMouseUp(const Wt::WMouseEvent &);
    void onDoubleClick(const Wt::WMouseEvent &);
public:
    void select(bool b = true);
    static bool mouseWentDown_;
    static bool doubleClicked_;
};

#endif /* IMCWIDGET_H_ */
