
#include <Wt/WGlobal>
#include <Wt/WApplication>
#include <Wt/WPaintedWidget>
#include <Wt/WPainter>

using namespace Wt;

class SomePaintedWidget : public WPaintedWidget {
public:
    SomePaintedWidget(WContainerWidget* p=0)
        : WPaintedWidget(p) {
            resize(600, 600);
            setPreferredMethod(WPaintedWidget::PngImage);
        }

protected:
    void paintEvent(Wt::WPaintDevice* device) {
        WPainter painter(device);
        // comment out this to reproduce bug
        WPen pen = painter.pen();
        pen.setWidth(10);
        painter.setPen(pen);
        //
        painter.drawRect(10, 10, 400, 200);
    }
};

class MyApp : public WApplication {
public:
    MyApp(const WEnvironment& env):
        WApplication(env) {
        SomePaintedWidget* spw = new SomePaintedWidget(root());
    }
};

WApplication* createApplication(const WEnvironment& env) {
    return new MyApp(env);
}

int main(int argc, char** argv) {
    return WRun(argc, argv, &createApplication);
}

