
#include <Wt/WGlobal>
#include <Wt/WApplication>
#include <Wt/WPaintedWidget>
#include <Wt/WPainter>

using namespace Wt;

class SomePaintedWidget : public WPaintedWidget {
public:
    SomePaintedWidget(WContainerWidget* p=0)
        : WPaintedWidget(p) {
            resize(600, 600);
            setPreferredMethod(WPaintedWidget::PngImage);
        }

protected:
    void paintEvent(Wt::WPaintDevice* device) {
        WPainter painter(device);

	/* Solution 1: enable anti-aliasing */
	painter.setRenderHint(WPainter::Antialiasing);

	/* Solution 2: position line in the middle of a pixel */
        painter.drawRect(10.5, 10.5, 400, 200);
    }
};

class MyApp : public WApplication {
public:
    MyApp(const WEnvironment& env):
        WApplication(env) {
        SomePaintedWidget* spw = new SomePaintedWidget(root());
    }
};

WApplication* createApplication(const WEnvironment& env) {
    return new MyApp(env);
}

int main(int argc, char** argv) {
    return WRun(argc, argv, &createApplication);
}

