#include <Wt/WServer>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WBreak>
#include <Wt/WMenuItem>
#include <Wt/WTabWidget>
#include <Wt/WTextArea>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
  ~TestApplication();

private:
  Wt::WBootstrapTheme *bs_theme_;
};

TestApplication::TestApplication(const WEnvironment& env)
  : WApplication(env), bs_theme_(0)
{
  setTitle("tabwidget without js issue");
  if (env.getParameter("polished")) {
    setCssTheme("polished");
  }
  else {
    bs_theme_ = new Wt::WBootstrapTheme();
    setTheme(bs_theme_);
  }

  WContainerWidget *w = new WContainerWidget(root());
  new WText("Use URL parameter 'polished' to choose polished theme.", w);

  new WBreak(w);

  WTabWidget *tabW = new WTabWidget(w);
  tabW->addTab(new WTextArea("Contents of tab 1."),
               "First", WTabWidget::PreLoading);
  tabW->addTab(new WTextArea("Contents of tab 2."),
               "Second", WTabWidget::PreLoading);
  tabW->addTab(new WTextArea("Contents of tab 3."),
               "Third", WTabWidget::PreLoading);
}

TestApplication::~TestApplication()
{
  delete bs_theme_;
}

WApplication *createApplication(const WEnvironment& env)
{
  return new TestApplication(env);
}

int main(int argc, char **argv)
{
  int status = WRun(argc, argv, &createApplication);
  return status;
}
