#include <Wt/WApplication>
#include <Wt/WLabel>
#include <Wt/WPushButton>
#include <Wt/WContainerWidget>
#include <Wt/WStackedWidget>
#include <Wt/WHBoxLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WText>
#include <Wt/WSpinBox>
#include <iostream>

using namespace Wt;


WSpinBox* mySpinBox()
{
   WSpinBox *myspinbox = new WSpinBox();
   myspinbox->setWidth(50);
   // wt 3.3.0 seems to use the maximum width instead of current width for layout calcuation!?
   // if maximum size is also set to 50 it looks good!
   //myspinbox->setMaximumSize(50, WLength::Auto);
   return myspinbox;
}

class Test : public WApplication
{
public:
  Test(const WEnvironment& env) 
   : WApplication(env)
  {
     WHBoxLayout *layout = new WHBoxLayout(root());
     root()->setMaximumSize(WLength::Auto, 1000);
     layout->addWidget(new WText("Text 1"), 0, AlignLeft|AlignMiddle);
     layout->addWidget(mySpinBox(), 0, AlignLeft|AlignMiddle);
     layout->addWidget(new WText("myspin 1"), 0, AlignLeft|AlignMiddle);
     layout->addWidget(mySpinBox(), 0, AlignLeft|AlignMiddle);
     layout->addWidget(new WText("myspin 2"), 0, AlignLeft|AlignMiddle);
     layout->addStretch(1);
     layout->addWidget(new WText("Text 4"), 0, AlignLeft|AlignMiddle);
  }

  void foo() {
  }
};

WApplication *createApplication(const WEnvironment& env){
  return new Test(env);
}

int main(int argc, char *argv[]){
  return WRun(argc, argv, createApplication);
}
