#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WGridLayout>
#include <Wt/WText>
#include <Wt/WLineEdit>
#include <Wt/WVBoxLayout>
#include <Wt/WTabWidget>
using namespace Wt;

class TestWidget : public Wt::WContainerWidget
{
  public:
    TestWidget(WContainerWidget *pParent = 0);
    virtual ~TestWidget()
    {
    }
};

TestWidget::TestWidget(WContainerWidget *pParent)
  : WContainerWidget(pParent)
{
  bool CREATE_PROBLEM = true;
  if (CREATE_PROBLEM)
  {
  // PROBLEM: Parent layout is not 70/30, it's completely wrong
    WVBoxLayout *v = new WVBoxLayout(this);
    v->addWidget (new Wt::WLineEdit());
  }
  else
  {
    // SOLUTION: Replace above code with this and the parent layout is correct, 70/30
    this->addWidget (new Wt::WLineEdit());
  }
}

class Test : public WApplication
{
    public:
        Test(const Wt::WEnvironment& env);
};

Test::Test(const Wt::WEnvironment& env)
    : Wt::WApplication(env)
{
  WGridLayout* l = new WGridLayout(root());

  l->setColumnResizable (0,false);
  l->setColumnResizable (1,true);
  l->setColumnStretch(0,0);
  l->setColumnStretch(1,70);
  l->setColumnStretch(2,30);

  l->setRowStretch(0,0);
  l->setRowStretch(1,1);
  l->setRowStretch(2,0);

  l->addWidget (new Wt::WLineEdit (),1,1,Wt::AlignTop);

  Wt::WTabWidget* t (new Wt::WTabWidget (0));
  t->addTab(new TestWidget(),"Test",Wt::WTabWidget::PreLoading);
  l->addWidget (t,1,2,Wt::AlignTop);
}

WApplication* createApplication(const Wt::WEnvironment& env)
{
    return new Test(env);
}

int main(int argc, char *argv[])
{
   return Wt::WRun(argc, argv, &createApplication);
}
