#include <Wt/WServer>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WBreak>
#include <Wt/WPaintedWidget>
#include <Wt/WPainter>
#include <Wt/WBrush>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
  ~TestApplication();

private:
  Wt::WBootstrapTheme *bs_theme_;
};

class TestPaintedWidget : public WPaintedWidget
{
public:
  TestPaintedWidget(const char* color, WContainerWidget *parent = 0);
  void paintEvent(WPaintDevice *paint_device);

private:
  std::string color_;
};  

TestPaintedWidget::TestPaintedWidget(const char* color, WContainerWidget *parent) :
  WPaintedWidget(parent), color_(color)
{
}

void TestPaintedWidget::paintEvent(WPaintDevice *paint_device)
{
  WPainter painter(paint_device);

  painter.setPen(NoPen);
  painter.setBrush(WBrush(WColor(color_)));
  painter.drawRect(0, 0, 100, 100);
}


TestApplication::TestApplication(const WEnvironment& env)
  : WApplication(env), bs_theme_(0)
{
  setTitle("WPaintedWidget Inline (test for IE10)");
  bs_theme_ = new Wt::WBootstrapTheme();
  setTheme(bs_theme_);

  WContainerWidget *w = new WContainerWidget(root());
  new WText("The following two WPaintedWidget objects are inline and should appear side-by-side.", w);

  new WBreak(w);

  WPaintedWidget *paint1 = new TestPaintedWidget("red", w);
  paint1->setInline(true);
  paint1->resize(100, 100);

  WPaintedWidget *paint2 = new TestPaintedWidget("green", w);
  paint2->setInline(true);
  paint2->resize(100, 100);
}

TestApplication::~TestApplication()
{
  delete bs_theme_;
}

WApplication *createApplication(const WEnvironment& env)
{
  return new TestApplication(env);
}

int main(int argc, char **argv)
{
  int status = WRun(argc, argv, &createApplication);
  return status;
}
