#include <Wt/WServer>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WBreak>
#include <Wt/WPushButton>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
  void handleButton1Click(WPushButton* button);
  void handleButton2Click(WPushButton* button);
  ~TestApplication();

private:
  Wt::WBootstrapTheme *bs_theme_;
  WContainerWidget *logw_;
};

TestApplication::TestApplication(const WEnvironment& env)
  : WApplication(env), bs_theme_(0)
{
  setTitle("Lost WPushbutton Style");
  bs_theme_ = new Wt::WBootstrapTheme();
  setTheme(bs_theme_);

  WContainerWidget *w = new WContainerWidget(root());
  new WText("Press the buttons to observe lost style classes. "
      "Button 1 loses theme-provided 'btn' style after toggleStyleClass. "
      "Button 2 loses user-provided 'btn-success' style after setLink()", w);
  new WBreak(w);

  // loses theme-provided btn style after toggleStyleClass
  WContainerWidget *button_container = new WContainerWidget(w);
  button_container->resize(WLength::Auto, 30);
  WPushButton *button1 = new WPushButton(button_container);
  button1->setText("Button1: Bootstrap Default Style, press to addStyleClass(\"btn-large\")");
  button1->clicked().connect(boost::bind(&TestApplication::handleButton1Click, this, button1));

  // loses user-provided btn-success after setLink
  WPushButton *button2 = new WPushButton(button_container);
  button2->setText("Button2: Bootstrap Success Style, press to setLink(\"/\")");
  button2->addStyleClass("btn-success");
  button2->clicked().connect(boost::bind(&TestApplication::handleButton2Click, this, button2));

  new WBreak(w);
  logw_ = new WContainerWidget(w);
}

void TestApplication::handleButton1Click(WPushButton* button)
{
  WString style = button->styleClass();
  new WText("button1 style (before): '" + style + "'", logw_);
  new WBreak(logw_);
  bool already_large = button->hasStyleClass("btn-large");

  button->toggleStyleClass("btn-large", !already_large);

  style = button->styleClass();
  new WText("button1 style (after): '" + style + "'", logw_);
  new WBreak(logw_);
}

void TestApplication::handleButton2Click(WPushButton* button)
{
  WString style = button->styleClass();
  new WText("button2 style (before): '" + style + "'", logw_);
  new WBreak(logw_);

  button->setLink(WLink("/"));

  style = button->styleClass();
  new WText("button2 style (after): '" + style + "'", logw_);
  new WBreak(logw_);
}

TestApplication::~TestApplication()
{
  delete bs_theme_;
}

WApplication *createApplication(const WEnvironment& env)
{
  return new TestApplication(env);
}

int main(int argc, char **argv)
{
  int status = WRun(argc, argv, &createApplication);
  return status;
}
