/*
 * Copyright (C) 2009 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include "mir_sp_synat_item_delegate.h"

#include "Wt/WAbstractItemModel"
#include "Wt/WAnchor"
#include "Wt/WApplication"
#include "Wt/WCheckBox"
#include "Wt/WContainerWidget"
#include "Wt/WEnvironment"
#include "Wt/WImage"
#include "Wt/WModelIndex"
#include "Wt/WHBoxLayout"
#include "Wt/WText"
#include "Wt/WTimer"

namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {
			using namespace Wt;

class SImage;

template <class Widget>
class IndexEdit : public Widget
{
public:
  IndexEdit(const WModelIndex& index)
    : index_(index)
  { }

  void setIndex(const WModelIndex& index) {
    index_ = index;
  }

  const WModelIndex& index() const {
    return index_;
  }

private:
  WModelIndex index_;
};

#ifdef WT_CNOR
class IndexCheckBox : public IndexEdit<WCheckBox>
{
public:
  IndexCheckBox(const WModelIndex& index);

  void setIndex(const WModelIndex& index);
  const WModelIndex& index();
};
#endif // WT_CNOR

SItemDelegate::SItemDelegate(WObject *parent)
  : WAbstractItemDelegate(parent), m_oldClickedImg(0), m_timer(0)
{ }

SItemDelegate::~SItemDelegate()
{ if (m_timer)
  {
		delete m_timer;
	}
}

void SItemDelegate::setTextFormat(const WT_USTRING& format)
{
  textFormat_ = format;
}

WWidget *SItemDelegate::update(WWidget *widget, const WModelIndex& index,
			       WFlags<ViewItemRenderFlag> flags)
{
  bool editing = widget && widget->find("t") == 0;

 // if (flags & RenderEditing) {
 //   if (!editing) {
 //     widget = createEditor(index, flags);
 //     WInteractWidget *iw = dynamic_cast<WInteractWidget *>(widget);
 //     if (iw) {
	//// Disable drag & drop and selection behaviour
	//iw->mouseWentDown().preventPropagation();
	//iw->clicked().preventPropagation();
 //     }
 //   }
 // } else {
 //   if (editing)
 //     widget = 0;
 // }

  WidgetRef widgetRef(widget);

  bool isNew = false;

  if (!(flags & RenderEditing)) {
    if (!widgetRef.w) {
      isNew = true;
			WContainerWidget *wc = new WContainerWidget();
			wc->setObjectName("o");
      widgetRef.w = wc;
    }

    if (!index.isValid())
      return widgetRef.w;

		WContainerWidget *wc = dynamic_cast<WContainerWidget *>(widgetRef.w);
		if (!isNew)
			wc->clear();
    SImage *imgPlayPause = new SImage(this, WLink("play.png"));
		SImage *stop = new SImage(this, WLink("stop.png"));
		//WText *mp = new WText(WString::fromUTF8("1"));
		imgPlayPause->setAttributeValue("style", "margin-right: 3px");
		wc->addWidget(imgPlayPause);
		wc->addWidget(stop);
		// add player controls
		boost::any linkData = index.data(LinkRole); 
		if (!linkData.empty()) 
		{
      WLink link = boost::any_cast<WLink>(linkData);
			
			imgPlayPause->clicked().connect(boost::bind(&SItemDelegate::slt_play_pause, this, link, imgPlayPause));
			stop->clicked().connect(boost::bind(&SItemDelegate::slt_stop, this, imgPlayPause));
			this->m_player->ended().connect(boost::bind(&SItemDelegate::slt_stop, this, imgPlayPause));
			//WText *play = new WText(WString::fromUTF8("Play"));
			//mp->setButton(WMediaPlayer::Play, play);
			//wc->addWidget(play);

			//WText *stop = new WText(WString::fromUTF8("Stop"));
			//mp->setButton(WMediaPlayer::Stop, play);
			//wc->addWidget(stop);
    } 

  }

	
  return widgetRef.w;
}

void SItemDelegate::slt_stop(SImage *img)
{
	if (m_oldClickedImg)
	{
		m_oldClickedImg->setImageLink(WLink("play.png"));
	}
	img->setImageLink(WLink("play.png"));
	this->m_player->stop();
	this->m_timer->stop();
}

void SItemDelegate::slt_play_pause(WLink link, SImage *img)
{
	std::string cont = link.url();
	WLink oldLink = this->m_player->getSource(WMediaPlayer::MP3);
	if (m_oldClickedImg == 0)
	{
		this->m_player->clearSources();
		this->m_player->addSource(WMediaPlayer::MP3, link);
		oldLink = link;
	}
	if (link == oldLink)
	{
		if (this->m_player->playing())
		{
			this->m_player->pause();
			img->setImageLink(WLink("play.png"));
		}
		else
		{
			if (!m_timer)
			{
				m_timer = new WTimer();
				m_timer->setInterval(100);
			}
			m_timer->timeout().connect(this, &SItemDelegate::slt_doMplayerHasDataToPlay);
			m_timer->start();
			img->setImageLink(WLink("pause.png"));
		}

	}
	else
	{
		if (m_oldClickedImg)
		{
			m_oldClickedImg->setImageLink(WLink("play.png"));
		}
		this->m_player->stop();
		this->m_player->clearSources();
		this->m_player->addSource(WMediaPlayer::MP3, link);
		if (!m_timer)
		{
			m_timer = new WTimer();
			m_timer->setInterval(100);
		}
		m_timer->timeout().connect(this, &SItemDelegate::slt_doMplayerHasDataToPlay);
		m_timer->start();
		img->setImageLink(WLink("pause.png"));
	}
	m_oldClickedImg = img;
}

void SItemDelegate::slt_doMplayerHasDataToPlay()
{
	int readyState = this->m_player->readyState();
	if (readyState >= WMediaPlayer::HaveMetaData)
	{
		m_player->play();
		m_timer->stop();
	}
}

void SItemDelegate::setMediaPlayer(WMediaPlayer *mp)
{
	this->m_player = mp;
}

/*
 * Possible layouts:
 *  1) WText "t"
 * or
 *  2) WContainerWidget "o" ([WCheckbox "c"] [WImage "i"] [inv] WText "t")
 * or
 *  3) WAnchor "a" ([WImage "i"] [inv] WText "t")
 * or
 *  4) WContainerWidget "o" ([WCheckbox "c"] WAnchor "a" ([Image "i"] [inv] WText "t"))
 */

IndexCheckBox *SItemDelegate::checkBox(WidgetRef& w, const WModelIndex& index,
				      bool autoCreate, bool triState)
{
  IndexCheckBox *checkBox = dynamic_cast<IndexCheckBox *>(w.w->find("c"));

  if (!checkBox) {
    if (autoCreate) {
      IndexCheckBox * const result = checkBox = new IndexCheckBox(index);

      checkBox->setObjectName("c");
      checkBox->clicked().preventPropagation();

      WContainerWidget *wc = dynamic_cast<WContainerWidget *>(w.w->find("o"));
      if (!wc) {
	wc = new WContainerWidget();
	wc->setObjectName("o");
	w.w->setInline(true);
	w.w->setStyleClass(WString::Empty);

	/* We first remove to avoid reparenting warnings */
	WContainerWidget *p = dynamic_cast<WContainerWidget *>(w.w->parent());
	if (p)
	  p->removeWidget(w.w);

	wc->addWidget(w.w);
	w.w = wc;
      }
      
      wc->insertWidget(0, checkBox);
      checkBox->changed().connect
	(boost::bind(&SItemDelegate::onCheckedChange, this, result));
    } else
      return 0;
  }

  checkBox->setTristate(triState);

  return checkBox;
}

WText *SItemDelegate::textWidget(WidgetRef& w)
{
  return dynamic_cast<WText *>(w.w->find("t"));
}

WMediaPlayer *SItemDelegate::playerWidget(WidgetRef& w)
{
  return dynamic_cast<WMediaPlayer *>(w.w->find("mp"));
}

WImage *SItemDelegate::iconWidget(WidgetRef& w, bool autoCreate)
{
  WImage *image = dynamic_cast<WImage *>(w.w->find("i"));
  if (image || !autoCreate)
    return image;

  WContainerWidget *wc = dynamic_cast<WContainerWidget *>(w.w->find("a"));

  if (!wc)
    wc = dynamic_cast<WContainerWidget *>(w.w->find("o"));

  if (!wc) {
    wc = new WContainerWidget();
    wc->setObjectName("o");
    wc->addWidget(w.w);
    w.w = wc;
  }

  image = new WImage();
  image->setObjectName("i");
  image->setStyleClass("icon");
  wc->insertWidget(wc->count() - 1, image);

  // IE does not want to center vertically without this:
  if (wApp->environment().agentIsIE()) {
    WImage *inv = new WImage(wApp->onePixelGifUrl());
    inv->setStyleClass("rh w0 icon");
    inv->resize(0, WLength::Auto);
    wc->insertWidget(wc->count() -1, inv);
  }

  return image;
}

WAnchor *SItemDelegate::anchorWidget(WidgetRef& w)
{
  WAnchor *anchor = dynamic_cast<WAnchor *>(w.w->find("a"));
  if (anchor)
    return anchor;

  anchor = new WAnchor();
  anchor->setObjectName("a");

  WContainerWidget *wc = dynamic_cast<WContainerWidget *>(w.w->find("o"));
  if (wc) {
    /*
     * Convert (2) -> (4)
     */
    int firstToMove = 0;

    WCheckBox *cb = dynamic_cast<WCheckBox *>(wc->widget(0));
    if (cb)
      firstToMove = 1;

    wc->insertWidget(firstToMove, anchor);

    while (wc->count() > firstToMove + 1) { 
      WWidget *c = wc->widget(firstToMove + 1);
      wc->removeWidget(c);
      anchor->addWidget(c);
    }
  } else {
    /*
     * Convert (1) -> (3)
     */
    anchor->addWidget(w.w);
    w.w = anchor;
  }

  return anchor;
}

void SItemDelegate::updateModelIndex(WWidget *widget, const WModelIndex& index)
{
  WidgetRef w(widget);

  if (index.flags() & ItemIsUserCheckable) {
    IndexCheckBox *cb = checkBox(w, index, false, false);
    if (cb)
      cb->setIndex(index);
  }
}

void SItemDelegate::onCheckedChange(IndexCheckBox *cb) const
{
  WAbstractItemModel *model
    = const_cast<WAbstractItemModel *>(cb->index().model());

  if (cb->isTristate())
    model->setData(cb->index(), boost::any(cb->checkState()), CheckStateRole);
  else
    model->setData(cb->index(), boost::any(cb->isChecked()), CheckStateRole);
}

WWidget *SItemDelegate::createEditor(const WModelIndex& index,
				     WFlags<ViewItemRenderFlag> flags) const
{
  WContainerWidget *const result = new WContainerWidget();
  result->setSelectable(true);

  WLineEdit *lineEdit = new WLineEdit();
  lineEdit->setText(asString(index.data(EditRole), textFormat_));
  lineEdit->enterPressed().connect
    (boost::bind(&SItemDelegate::doCloseEditor, this, result, true));
  lineEdit->escapePressed().connect
    (boost::bind(&SItemDelegate::doCloseEditor, this, result, false));
  lineEdit->escapePressed().preventPropagation();

  if (flags & RenderFocused)
    lineEdit->setFocus();

  // We use a layout so that the line edit fills the entire cell.
  // Somehow, this does not work with konqueror, but it does respond
  // properly to width, height being set to 100% !
  WApplication *app = WApplication::instance();
  if (app->environment().agent() != WEnvironment::Konqueror) {
    result->setLayout(new WHBoxLayout());
    result->layout()->setContentsMargins(1, 1, 1, 1);
    result->layout()->addWidget(lineEdit);
  } else {
    lineEdit->resize(WLength(100, WLength::Percentage),
		     WLength(100, WLength::Percentage));
    result->addWidget(lineEdit);
  }

  return result;
}

void SItemDelegate::doCloseEditor(WWidget *editor, bool save) const
{
  closeEditor().emit(editor, save);
}

boost::any SItemDelegate::editState(WWidget *editor) const
{
  WContainerWidget *w = dynamic_cast<WContainerWidget *>(editor);
  WLineEdit *lineEdit = dynamic_cast<WLineEdit *>(w->widget(0));

  return boost::any(lineEdit->text());
}

void SItemDelegate::setEditState(WWidget *editor, const boost::any& value) const
{
  WContainerWidget *w = dynamic_cast<WContainerWidget *>(editor);
  WLineEdit *lineEdit = dynamic_cast<WLineEdit *>(w->widget(0));

  lineEdit->setText(boost::any_cast<WT_USTRING>(value));
}

void SItemDelegate::setModelData(const boost::any& editState,
				 WAbstractItemModel *model,
				 const WModelIndex& index) const
{
  model->setData(index, editState, EditRole);
}



}
}
}