#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WLogger>
#include <Wt/WEnvironment>
#include <Wt/WLength>
#include <Wt/WTable>
#include <Wt/WTableCell>
#include <Wt/Dbo/Dbo>
#include <Wt/WEvent>
#include <Wt/WText>
#include <Wt/WLabel>
#include <Wt/WValidator>
#include <Wt/WIntValidator>
#include <Wt/WLengthValidator>
#include <Wt/WCheckBox>
#include <Wt/WComboBox>
#include <Wt/WTextArea>
#include <Wt/WMediaPlayer>
#include <Wt/WFileResource>
#include <Wt/WImage>
#include <Wt/WLink>
#include <Wt/WPushButton>
#include <Wt/WMessageBox>
#include <Wt/WSuggestionPopup>
#include <Wt/WTemplate>
#include <Wt/WTableView>
#include <Wt/WAnchor>
#include <Wt/WStandardItemModel>
#include <Wt/WStandardItem>

#include <vector>
#include <iostream>
#include <stdio.h>

#include <boost/lexical_cast.hpp>
#include <boost/ptr_container/ptr_vector.hpp>
#include <boost/any.hpp>
#include <boost/filesystem.hpp>
#include <boost/cast.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/bind.hpp>
#include <boost/foreach.hpp>

#include "utils/mir_internalpaths.h"
#include "utils/mir_trkeys.h"
#include "utils/mir_defines.h"
#include "utils/mir_cssconsts.h"
#include "utils/mir_cssclasses.h"
#include "controls/mir_sp_controlswidget.h"
#include "controls/mir_sp_explorercontrols.h"
#include "mir_sp_synatpgapp.h"
#include "mir_sp_synat_item_delegate.h"

#define MIR_DEF_MARGIN_FOR_TAG 15

namespace SyNaT
{
  namespace MIR
  {
    namespace SP
    {
      using namespace std;
      using namespace Wt;

      WWidget *ExplorerControls::create_explorer_controls()
      {

        WTable *wtab = new WTable();
				wtab->setWidth(1380);
		this->m_rows = 20;
        wtab->setMargin(WLength::Auto, Left | Right);
        WTableCell *cell = wtab->elementAt(0,0);

        this->m_wtv = new WTableView();
        //this->m_wtv->setRowsPerPage(20);
        int cols = 7, colWidth = 120;
		
		WStandardItemModel *qmodel = new WStandardItemModel();
		qmodel->insertColumns(qmodel->columnCount(), 7);
		// Set data in the model.
		qmodel->insertRows(qmodel->rowCount(), 1);
		int column = 0, row = 0;
		WStandardItem *item = new WStandardItem();
		item->setText(WString::fromUTF8("Artist " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, item);

		item = new WStandardItem();
		item->setText(WString::fromUTF8("Title " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, item);

		item = new WStandardItem();
		item->setText(WString::fromUTF8("Genre " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, item);

		item = new WStandardItem();
		item->setText(WString::fromUTF8("Album " + boost::lexical_cast<string>(row)));

		qmodel->setItem(row, column++, item);

		item = new WStandardItem();
		item->setText(WString::fromUTF8("Year " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, item);

		item = new WStandardItem();
		item->setText(WString::fromUTF8("Track " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, item);

		item = new WStandardItem();

		item->setLink(WLink("1.mp3"));
		qmodel->setItem(row, column++, item);
		row++;
		column = 0;
		qmodel->setItem(row, column++, new WStandardItem("Artist " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, new WStandardItem("Title " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, new WStandardItem("Genre " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, new WStandardItem("Album " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, new WStandardItem("Year " + boost::lexical_cast<string>(row)));
		qmodel->setItem(row, column++, new WStandardItem("Track " + boost::lexical_cast<string>(row)));

		item = new WStandardItem();

		item->setLink(WLink("2.mp3"));
		qmodel->setItem(row, column++, item);
		row++;
		column = 0;



        this->m_wtv->setSortingEnabled(0, false);
        this->m_wtv->setSortingEnabled(1, false);
        this->m_wtv->setSortingEnabled(2, false);
        this->m_wtv->setSortingEnabled(3, false);
        this->m_wtv->setSortingEnabled(4, false);
        this->m_wtv->setSortingEnabled(5, false);
        this->m_wtv->setSortingEnabled(6, false);


				WMediaPlayer *mp = new WMediaPlayer(WMediaPlayer::Audio, cell);
				mp->addSource(WMediaPlayer::MP3, WLink("Maroon5.mp3"));
				mp->setControlsWidget(0);
				//mp->addStyleClass("vis-hidden");
				SItemDelegate *id = new SItemDelegate(wtab);
				id->setMediaPlayer(mp);
				this->m_wtv->setItemDelegateForColumn(6, id);

				qmodel->setHeaderData(0, Horizontal, WString::fromUTF8("Artist"));
				qmodel->setHeaderData(1, Horizontal, WString::fromUTF8("Title"));
				qmodel->setHeaderData(2, Horizontal, WString::fromUTF8("Genre"));
				qmodel->setHeaderData(3, Horizontal, WString::fromUTF8("Album"));
				qmodel->setHeaderData(4, Horizontal, WString::fromUTF8("Year"));
				qmodel->setHeaderData(5, Horizontal, WString::fromUTF8("Track"));
				qmodel->setHeaderData(6, Horizontal, WString::fromUTF8("Play"));


    //    if(this->m_dm->isUser(MIR_MUSIC_FILE_DOWNLOADER))
				//{
    //      this->m_wtv->setSortingEnabled(10, false);
				//	this->m_wtv->setSortingEnabled(11, false);
				//	this->m_wtv->setSortingEnabled(12, false);
				//	this->m_wtv->setItemDelegateForColumn(12, id);
				//}
				//else
				//{
				//	this->m_wtv->setSortingEnabled(10, false);
				//	this->m_wtv->setSortingEnabled(11, false);
				//	this->m_wtv->setItemDelegateForColumn(11, id);
				//}

				


        this->m_wtv->setRowHeight(22);

        for (int i = 0; i < cols ; i++)
        {
          this->m_wtv->setColumnWidth(i, colWidth);
        }
     //   if (this->m_dm->isUser(MIR_MUSIC_FILE_DOWNLOADER))
     //   {
					//this->m_wtv->setColumnWidth(cols - 5, 80);
					//this->m_wtv->setColumnWidth(cols - 4, 80);
     //     this->m_wtv->setColumnWidth(cols - 3, 80);
     //     this->m_wtv->setColumnWidth(cols - 2, 80);
     //     this->m_wtv->setColumnWidth(cols - 1, 80);
					//this->m_wtv->setColumnWidth(cols, 80);
     //   }
     //   else
     //   {
     //     this->m_wtv->setColumnWidth(cols - 5, 120);
     //     this->m_wtv->setColumnWidth(cols - 4, 80);
     //     this->m_wtv->setColumnWidth(cols - 3, 80);
					//this->m_wtv->setColumnWidth(cols - 2, 80);
					//this->m_wtv->setColumnWidth(cols - 1, 80);
					//this->m_wtv->setColumnWidth(cols, 80);
     //   }

        this->m_wtv->resize(1380, 20 + this->m_rows * 22 + 120);
//        this->m_wtv->setAlternatingRowColors(true);
        this->m_wtv->setSelectable(true);
        //if (WApplication::instance()->environment().ajax())
        //{
        //  this->m_wtv->searchLineEdit().keyWentUp().connect(this, &ExplorerControls::slt_changeQueryAndReloadModel);
        //  this->m_wtv->searchCheckBoxLike().changed().connect(this, &ExplorerControls::slt_changeQueryAndReloadModel);
        //}
        //this->m_wtv->searchComboBox().addItem(tr(MIR_WCTV_ALL_CATEGORIES));
	    this->m_wtv->setModel(qmodel);
		cell->addWidget(this->m_wtv);
        this->m_was_rendered = true;
        
        return wtab;
      }

    }
  }
}
