#include <boost/test/unit_test.hpp>

#include <Wt/Dbo/Dbo>
#include <Wt/Dbo/backend/Postgres>
#include <Wt/Dbo/backend/MySQL>
#include <Wt/Dbo/backend/Sqlite3>
#include <Wt/Dbo/backend/Firebird>
#include <Wt/WDate>
#include <Wt/WDateTime>
#include <Wt/WTime>
#include <Wt/Dbo/WtSqlTraits>
#include <Wt/Dbo/ptr_tuple>

namespace dbo = Wt::Dbo;

class DailyLog : public Wt::Dbo::Dbo<DailyLog>
{
public:
	Wt::WDate	Date;
	int			RRClicks;
	double		RevenuePerRRClick;
	int			DRClicks;
	double		RevenuePerDRClick;
	double		RecycleCost;
	double		OtherRevenues;
	double		OtherCosts;

	template<class Action>
	void persist(Action &a)
	{
		Wt::Dbo::field(a, Date, "Date");
		Wt::Dbo::field(a, RRClicks, "RRClicks");
		Wt::Dbo::field(a, RevenuePerRRClick, "RevenuePerRRClick");
		Wt::Dbo::field(a, DRClicks, "DRClicks");
		Wt::Dbo::field(a, RevenuePerDRClick, "RevenuePerDRClick");
		Wt::Dbo::field(a, OtherRevenues, "OtherRevenues");
		Wt::Dbo::field(a, RecycleCost, "RecycleCost");
		Wt::Dbo::field(a, OtherCosts, "OtherCosts");
	}
	static const char *TableName()
	{
		return "dailylogs";
	}
};

struct Dbo2Fixture
{
  Dbo2Fixture()
  {
    connection_ = new dbo::backend::Sqlite3(":memory:");
    connection_->setProperty("show-queries", "true");

    session_ = new dbo::Session();
    session_->setConnection(*connection_);

    session_->mapClass<DailyLog>(DailyLog::TableName());

    session_->createTables();
  }

  ~Dbo2Fixture()
  {
    session_->dropTables();

    delete session_;
    delete connection_;
  }

  dbo::SqlConnection *connection_;
  dbo::Session *session_;
};

BOOST_AUTO_TEST_CASE( dbo_test_saif )
{
  Dbo2Fixture f;

  dbo::Session& session = *f.session_;
  {
	  dbo::Transaction transaction(session);
	  DailyLog *d1 = new DailyLog;
	  d1->Date = Wt::WDate::currentServerDate();
	  d1->DRClicks = 0;
	  d1->OtherCosts = 5.123;
	  d1->OtherRevenues = 6.321;
	  d1->RecycleCost = 0.07;
	  d1->RevenuePerDRClick = 0.0005;
	  d1->RevenuePerRRClick = 0.01;
	  d1->RRClicks = 93;
	  session.add(d1);

	  DailyLog *d2 = new DailyLog;
	  d1->Date = Wt::WDate::currentServerDate().addDays(1);
	  d1->DRClicks = 8;
	  d1->OtherCosts = 0;
	  d1->OtherRevenues = 0;
	  d1->RecycleCost = 0.14;
	  d1->RevenuePerDRClick = 0.0005;
	  d1->RevenuePerRRClick = 0.01;
	  d1->RRClicks = 82;
	  session.add(d2);

	  transaction.commit();
  }
  
  typedef boost::tuple<int, double> tupel;
  typedef boost::tuple<int, int, double, double, double, double, double> DailyLogDataTupleType;

  dbo::Transaction transaction(session);
  tupel tupe = session.query<tupel>(std::string("SELECT \"RRClicks\", \"RevenuePerRRClick\" FROM \"") + DailyLog::TableName() + "\" LIMIT 1");
  std::cerr << "tupe: get<int>: " << tupe.get<0>() << ", get<double>:" << tupe.get<1>() << std::endl;
  std::cerr << "tupe: get<int>: " << tupe.get<0>() << ", get<double>:" << tupe.get<1>() << std::endl;
  std::cerr << "tupe: get<int>: " << tupe.get<0>() << ", get<double>:" << tupe.get<1>() << std::endl;
  DailyLogDataTupleType DailyLogDataTuple = session.query<DailyLogDataTupleType>(std::string("SELECT SUM(\"RRClicks\") AS test, SUM(\"DRClicks\"), SUM(\"RRClicks\" * \"RevenuePerRRClick\"), SUM(\"DRClicks\" * \"RevenuePerDRClick\"), SUM(\"OtherRevenues\"), SUM(\"RecycleCost\"), SUM(\"OtherCosts\") FROM \"") + DailyLog::TableName() + "\"");
  std::cerr << "DailyLogDataTuple: get<0>: " << DailyLogDataTuple.get<0>() << "get<1>: " << DailyLogDataTuple.get<1>() << "get<2>: " << DailyLogDataTuple.get<2>() << "get<3>: " << DailyLogDataTuple.get<3>() << "get<4>: " << DailyLogDataTuple.get<4>() << "get<5>: " << DailyLogDataTuple.get<5>() << "get<6>: " << DailyLogDataTuple.get<6>() << std::endl;
  std::cerr << "DailyLogDataTuple: get<0>: " << DailyLogDataTuple.get<0>() << "get<1>: " << DailyLogDataTuple.get<1>() << "get<2>: " << DailyLogDataTuple.get<2>() << "get<3>: " << DailyLogDataTuple.get<3>() << "get<4>: " << DailyLogDataTuple.get<4>() << "get<5>: " << DailyLogDataTuple.get<5>() << "get<6>: " << DailyLogDataTuple.get<6>() << std::endl;
  std::cerr << "DailyLogDataTuple: get<0>: " << DailyLogDataTuple.get<0>() << "get<1>: " << DailyLogDataTuple.get<1>() << "get<2>: " << DailyLogDataTuple.get<2>() << "get<3>: " << DailyLogDataTuple.get<3>() << "get<4>: " << DailyLogDataTuple.get<4>() << "get<5>: " << DailyLogDataTuple.get<5>() << "get<6>: " << DailyLogDataTuple.get<6>() << std::endl;
  transaction.commit();
}
