//-*-Mode: C++;-*-
#ifndef MYARM_APPS_WEB_ITEMTABLEVIEW_H
#define MYARM_APPS_WEB_ITEMTABLEVIEW_H

#include "myarmconfig.h"

#include "web/util/ItemViewAutoSize.h"

#include <Wt/WLength>
#include <Wt/WTableView>

namespace myarm
{

namespace web
{

class ItemTableView : public Wt::WTableView
{
   public:
      ItemTableView(Wt::WAbstractItemModel* model)
	 : WTableView()
	 , autoSize_(model, this)
      {
	 setModel(model);
	 setLayoutSizeAware(true);
	 setColumnResizeEnabled(false);
      }

      virtual void setColumnWidth(int column, const Wt::WLength& width)
      {
	 if(byPass_)
	    WTableView::setColumnWidth(column, width);
	 else
	    autoSize_.setColumnWidth(column, width);
      }
      virtual void setColumnHidden(int column, bool hidden)
      {
	 if(byPass_)
	    WTableView::setColumnHidden(column, hidden);
	 else
	    autoSize_.setColumnHidden(column, hidden);
      }

      void calcColumns()
      {
	 autoSize_.calcSize();
      }
   protected:
      virtual void layoutSizeChanged(int width, int height)
      {
	 byPass_ = true;
	 autoSize_.autoSize(width, height/rowHeight().toPixels());
	 byPass_ = false;
      }

   private:
      ItemViewAutoSize autoSize_;
      bool byPass_;
};

} // namespace web

} // namespace myarm


#endif
