//-*-Mode: C++;-*-
#ifndef MYARM_APPS_WEB_TABLEVIEWAUTOSIZE_H
#define MYARM_APPS_WEB_TABLEVIEWAUTOSIZE_H

#include "myarmconfig.h"

#include <Wt/WLength>
#include <Wt/WAbstractItemModel>
#include <Wt/WAbstractItemView>
#include <Wt/WModelIndex>

namespace myarm
{

namespace web
{

class ItemViewAutoSize
{
   public:
      /**
       * @brief Constructor.
       * @param parent       Parent WObject
       */
      ItemViewAutoSize(Wt::WAbstractItemModel* model,
		       Wt::WAbstractItemView* view);

      void setColumnWidth(int column, const Wt::WLength& width);
      void setColumnHidden(int column, bool hidden);

      void autoSize(int viewWidth, int visibleRows);
      void calcSize();

   protected:
      class Column
      {
	 public:
	    Column()
	       : width_(0)
	       , fixedWidth_(false)
	       , hidden_(false)
	       , count_(0)
	       , maxLength_(0)
	       , accLength_(0)
	    {
	    }

	    void clear()
	    {
	       width_ = 0;
	       fixedWidth_= false;
	       hidden_ = false;
	       count_ = 0;
	       maxLength_ = 0;
	       accLength_ = 0;
	    }

	    Wt::WLength width_; /**< Current width of the column */
	    bool fixedWidth_;   /**< This column has a fixed width */
	    bool hidden_;       /**< Is column hidden */
	    uint32_t count_;      /**< Number of items in column */
	    size_t maxLength_;  /**< Maximal string length over all itens. */
	    size_t accLength_;  /**< Accumulated string length over all items. */
      };

   private:
      void adjustColumns() const;
      void clearColumns();
      bool isHidden(int column) const;

   private:
      mutable std::vector<Column> columns_;
      Wt::WLength defColumnWidth_;
      size_t scrollBarWidth_;

      Wt::WAbstractItemModel* model_;
      Wt::WAbstractItemView* view_;
};

} // namespace web

} // namespace myarm


#endif
