#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WFileUpload>
#include <Wt/WMessageBox>

using namespace Wt;
using namespace std;

////////////////////////////////////////////////////////////////////
class TriggerWFileUploadBugWidget: public Wt::WContainerWidget {
public:
  TriggerWFileUploadBugWidget(Wt::WContainerWidget *parent = 0);

  virtual ~TriggerWFileUploadBugWidget() {
  }

private:
  Wt::WFileUpload *firstfileUpload;
  Wt::WFileUpload *secondfileUpload;
  Wt::WFileUpload *thirdfileUpload;

  bool haveFirstfile;
  bool haveSecondfile;
  bool haveThirdfile;

  WPushButton *loadButton;

  void doUpload();
  void firstfileUploaded();
  void secondfileUploaded();
  void thirdfileUploaded();
  void allFilesUploaded();
  void reset();
  void fileTooLarge(::int64_t size);
};


TriggerWFileUploadBugWidget::TriggerWFileUploadBugWidget(WContainerWidget *parent)
  :
  firstfileUpload(0),
  secondfileUpload(0),
  thirdfileUpload(0),
  WContainerWidget(parent)
{
  this->reset();
}

void TriggerWFileUploadBugWidget::reset() {
  this->clear();

  this->addWidget(new WText("First: "));
  firstfileUpload = new Wt::WFileUpload(this);
  firstfileUpload->setFileTextSize(40);

  firstfileUpload->uploaded().connect(this, &TriggerWFileUploadBugWidget::firstfileUploaded);
  firstfileUpload->fileTooLarge().connect(this, &TriggerWFileUploadBugWidget::fileTooLarge);

  this->addWidget(new WBreak());

  this->addWidget(new WText("Second: "));
  secondfileUpload = new Wt::WFileUpload(this);
  secondfileUpload->setFileTextSize(40);

  secondfileUpload->uploaded().connect(this, &TriggerWFileUploadBugWidget::secondfileUploaded);
  secondfileUpload->fileTooLarge().connect(this, &TriggerWFileUploadBugWidget::fileTooLarge);

  this->addWidget(new WBreak());

  this->addWidget(new WText("Third: "));
  thirdfileUpload = new Wt::WFileUpload(this);
  thirdfileUpload->setFileTextSize(40);

  thirdfileUpload->uploaded().connect(this, &TriggerWFileUploadBugWidget::thirdfileUploaded);
  thirdfileUpload->fileTooLarge().connect(this, &TriggerWFileUploadBugWidget::fileTooLarge);

  //
  this->addWidget(new WBreak());
  loadButton = new WPushButton("Load", this);

  loadButton->clicked().connect(this, &TriggerWFileUploadBugWidget::doUpload);

  loadButton->enable();

  {
    haveFirstfile=false;
    haveSecondfile=false;
    haveThirdfile=false;
  }
}

////////////////////////////////////////////////////////////////
void TriggerWFileUploadBugWidget::doUpload() {
  firstfileUpload->upload();
  secondfileUpload->upload();
  thirdfileUpload->upload();

  cerr << "Started upload" << endl;
  loadButton->disable();
}

void TriggerWFileUploadBugWidget::firstfileUploaded() {
  haveFirstfile=true;
  cerr << "Got firstfile" << endl;
  if (haveFirstfile && haveSecondfile && haveThirdfile)
    this->allFilesUploaded();
  cerr << "Leaving firstfileUploaded" << endl;
}

void TriggerWFileUploadBugWidget::secondfileUploaded() {
  haveSecondfile=true;
  cerr << "Got secondfile" << endl;
  if (haveFirstfile && haveSecondfile && haveThirdfile)
    this->allFilesUploaded();
  cerr << "Leaving secondfileUploaded" << endl;
}

void TriggerWFileUploadBugWidget::thirdfileUploaded() {
  haveThirdfile=true;
  cerr << "Got thirdfile" << endl;
  if (haveFirstfile && haveSecondfile && haveThirdfile)
    this->allFilesUploaded();
  cerr << "Leaving thirdfileUploaded" << endl;
}

void TriggerWFileUploadBugWidget::allFilesUploaded() {
  string firstfileClient=firstfileUpload->clientFileName().narrow();
  string secondfileClient=secondfileUpload->clientFileName().narrow();
  string thirdfileClient=thirdfileUpload->clientFileName().narrow();
  cerr << "Entered allFilesUploaded" << endl;

  WMessageBox::show("Files successfully uploaded","Got files: " + firstfileClient + " " + secondfileClient + " " + thirdfileClient,Ok);
  this->reset();
}

void TriggerWFileUploadBugWidget::fileTooLarge(::int64_t size) {
  WMessageBox::show("Error","File too large",Ok);
  this->reset();
}

WApplication *createApplication(const WEnvironment& env) {
  Wt::WApplication *app = new Wt::WApplication(env);
  
  app->setTitle("WFileUpload bug");

  new TriggerWFileUploadBugWidget(app->root());

  return app;
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}

