//============================================================================
// Name        : wittyTest2.cpp
// Author      : 
// Version     :
// Copyright   : Your copyright notice
// Description : Hello World in C++, Ansi-style
//============================================================================

#include <iostream>
#include <vector>



/*
 * Copyright (C) 2008 Emweb bvba, Heverlee, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WLineEdit>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WTableView>
#include <Wt/WStandardItemModel>
#include <Wt/WStandardItem>
#include <Wt/WTimer>
//#include <Wt/WGlobal>
#include <Wt/WString>
// c++0x only, for std::bind
// #include <functional>
using namespace std;
using namespace Wt;


/*
 * A simple hello world application class which demonstrates how to react
 * to events, read input, and give feed-back.
 */
class HelloApplication : public Wt::WApplication
{
public:
  HelloApplication(const Wt::WEnvironment& env);
  typedef std::vector<Wt::WStandardItem*> LLColumn;
  typedef std::vector<LLColumn> ColumnListVector;

private:
  Wt::WLineEdit *nameEdit_;
  Wt::WText *greeting_;
  Wt::WTableView* createLiveListListView();
  Wt::WStandardItemModel *model;
  Wt::WTableView *extLLTableView;
  Wt::WTimer *updateTimer;
  void greet();

  void initModel();
  void InternalUpdateModel();
  void updateModel();
  ColumnListVector GetVector();

};

/*
 * The env argument contains information about the new session, and
 * the initial request. It must be passed to the WApplication
 * constructor so it is typically also an argument for your custom
 * application constructor.
*/
HelloApplication::HelloApplication(const Wt::WEnvironment& env)
  : Wt::WApplication(env)
{
  setTitle("Hello world");                               // application title

  extLLTableView = new Wt::WTableView(root());

  extLLTableView->setSortingEnabled(true);
  extLLTableView->setAlternatingRowColors(true);

  model = new Wt::WStandardItemModel(root());
  extLLTableView->setModel(model);
  ColumnListVector ColList = GetVector();
  for (unsigned int col = 0; col < ColList.size(); col++)
  {
      model->insertColumn(col, ColList[col]);
  }

  updateTimer = new WTimer(root());
  updateTimer->setInterval(500);
  updateTimer->timeout().connect(SLOT(this, HelloApplication::updateModel));
  updateTimer->start();
}

HelloApplication::ColumnListVector HelloApplication::GetVector()
{
    ColumnListVector testColumnList;
    for (int i = 0; i < 6; i++)
    {
        testColumnList.push_back(std::vector<Wt::WStandardItem*>(1));
        testColumnList[i].clear();
    }
    for (unsigned int col = 0; col < 6; col++)
    {
        for(int i = 0; i < 35; i++)
        {
            testColumnList[col].push_back(new Wt::WStandardItem("test123"));
        }
    }
    return testColumnList;
}

void HelloApplication::updateModel()
{
    model->clear();

    ColumnListVector ColList = GetVector();
    for (unsigned int col = 0; col < ColList.size(); col++)
    {
        model->insertColumn(col, ColList[col]);
    }
}

Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
  /*
   * You could read information from the environment to decide whether
   * the user has permission to start a new application
   */
  return new HelloApplication(env);
}

int main(int argc, char **argv)
{
  return Wt::WRun(argc, argv, &createApplication);
}
