#include <Wt/WApplication>
#include <Wt/WVBoxLayout>
#include <Wt/WContainerWidget>
#include <Wt/WMenu>
#include <Wt/WPopupMenu>
#include <Wt/WStackedWidget>
#include <Wt/WNavigationBar>
#include <Wt/WBootstrapTheme>
#include <Wt/WLabel>
#include <Wt/WAnchor>

using namespace Wt;

class Test : public WApplication
{
  public:
    Test(const Wt::WEnvironment& env);
};

Test::Test(const Wt::WEnvironment& env)
    : Wt::WApplication(env)
{
  this->setTheme(new Wt::WBootstrapTheme(this));

  Wt::WContainerWidget* main = new Wt::WContainerWidget (this->root());

  Wt::WVBoxLayout* layout (new Wt::WVBoxLayout (0));

  Wt::WStackedWidget* stack (new Wt::WStackedWidget (0));

  Wt::WMenu* menu (new Wt::WMenu(stack, Wt::Horizontal, 0));
  menu->setInternalPathEnabled();

    Wt::WPopupMenu *submenu = new Wt::WPopupMenu(stack);
    submenu->setInternalPathEnabled();
    Wt::WMenuItem* mi = new Wt::WMenuItem("Colors");
    mi->setMenu(submenu);
    menu->addItem(mi);
    submenu->addItem("Black",new Wt::WLabel (Wt::WString("Black"),0))->setPathComponent("black");
    submenu->addItem("Brown",new Wt::WLabel (Wt::WString("Brown"),0))->setPathComponent("brown");

      Wt::WPopupMenu *subsubmenu = new Wt::WPopupMenu(stack);
      subsubmenu->setInternalPathEnabled();
      Wt::WMenuItem* mmi = new Wt::WMenuItem("Bright");
      mmi->setMenu(subsubmenu);
      submenu->addItem(mmi);

      subsubmenu->addItem("Red",new Wt::WLabel (Wt::WString("Red"),0))->setPathComponent("red");
      subsubmenu->addItem("Green",new Wt::WLabel (Wt::WString("Green"),0))->setPathComponent("green");

  Wt::WNavigationBar* navBar (new Wt::WNavigationBar(main));
  navBar->addMenu(menu);

  layout->addWidget(navBar,0);
  layout->addWidget(stack,1);
  main->setLayout (layout);
}

WApplication* createApplication(const Wt::WEnvironment& env)
{
    return new Test(env);
}

int main(int argc, char *argv[])
{
   return Wt::WRun(argc, argv, &createApplication);
}
