#include <Wt/WApplication>
#include <Wt/WVBoxLayout>
#include <Wt/WContainerWidget>
#include <Wt/WMenu>
#include <Wt/WPopupMenu>
#include <Wt/WStackedWidget>
#include <Wt/WNavigationBar>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class Test : public WApplication
{
  public:
    Test(const Wt::WEnvironment& env);
};

Test::Test(const Wt::WEnvironment& env)
    : Wt::WApplication(env)
{
  this->setTheme(new Wt::WBootstrapTheme(this));

  Wt::WContainerWidget* main = new Wt::WContainerWidget (this->root());

  Wt::WVBoxLayout* layout (new Wt::WVBoxLayout (0));

  Wt::WStackedWidget* stack (new Wt::WStackedWidget (0));

  Wt::WMenu* menu (new Wt::WMenu(stack, Wt::Horizontal, 0));

    Wt::WPopupMenu *submenu = new Wt::WPopupMenu();
    submenu->addItem("New");

    Wt::WMenuItem* smi = new Wt::WMenuItem("File");
    smi->setMenu(submenu);
    menu->addItem(smi);

    Wt::WPopupMenu *submenu2 = new Wt::WPopupMenu();
    submenu2->addItem("New2");

    Wt::WMenuItem* smi2 = new Wt::WMenuItem("File2");
    smi2->setMenu(submenu2);
    menu->addItem(smi2);

  Wt::WNavigationBar* navBar (new Wt::WNavigationBar(main));
  navBar->addMenu(menu);

  layout->addWidget(navBar);
  main->setLayout (layout);
}

WApplication* createApplication(const Wt::WEnvironment& env)
{
    return new Test(env);
}

int main(int argc, char *argv[])
{
   return Wt::WRun(argc, argv, &createApplication);
}
