#include <Wt/WApplication>
#include <Wt/WStandardItemModel>
#include <Wt/WStandardItem>
#include <Wt/WContainerWidget>
#include <Wt/WTableView>
#include <Wt/WTreeView>

using namespace Wt;

int cols = 0;
int rows = 0;

class TestApp : public WApplication
{
public:
  void createRow(std::vector<WStandardItem *>& row, int size,
		 const std::string& s) {

    row.clear();

    for (int i = 0; i < size; ++i) {
      WStandardItem *t
	= new WStandardItem(s + " c" + boost::lexical_cast<std::string>(i));

      row.push_back(t);
    }
  }

  WStandardItemModel *createModel() {
    WStandardItemModel *model_ = new WStandardItemModel(0, cols, this);

    for (int i = 0; i < cols; ++i)
      model_->setHeaderData(i, Horizontal,
			    "col " + boost::lexical_cast<std::string>(i));

    std::vector<WStandardItem *> row;

    for (unsigned i = 0; i < rows; ++i) {
      createRow(row, cols, "Item "+ boost::lexical_cast<std::string>(i));
      model_->appendRow(row);
    }

    return model_;
  }

  TestApp(const WEnvironment& env) : WApplication(env)
  {
    WStandardItemModel *model = createModel();

    WTableView *tv = new WTableView(root());
    tv->decorationStyle().setBorder(WBorder(WBorder::Solid, 1, black));
    tv->setHeight(250);
    tv->setModel(model);
    tv->setColumnWidth(0, Wt::WLength(240));
    
    WTreeView *trv = new WTreeView(root());
    trv->decorationStyle().setBorder(WBorder(WBorder::Solid, 1, black));
    trv->setHeight(250);
    trv->setModel(model);
    trv->setColumnWidth(0, Wt::WLength(240));

  }

  void foo() {
  }

private:
};

WApplication *createApplication(const WEnvironment& env)
{
  TestApp *app = new TestApp(env);

  return app;
}

int main(int argc, char *argv[])
{
  return WRun(argc, argv, &createApplication);
}
