#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WPushButton>
#include <Wt/WText>

using namespace Wt;

class MyApp : public WApplication
{
public:

    MyApp(const WEnvironment& env)
        : WApplication(env)
    {
      WPushButton* button1 = new WPushButton( "Button 1", root() );
      button1->clicked().connect( this, &MyApp::changePath1 );

      WPushButton* button2 = new WPushButton( "Button 2", root() );
      button2->clicked().connect( this, &MyApp::changePath2 );

      internalPathChanged().connect( this, &MyApp::handlePathChange );
    }

    void changePath1() { 
      std::cerr << "Button1 clicked" << std::endl;
      setInternalPath( "/page1", false );
    }

    void changePath2() {
      std::cerr << "Button2 clicked" << std::endl;
      setInternalPath( "/page2", true ); 
    }

    void handlePathChange( std::string path )
    {
      std::cout << "handlePathChange " << path << std::endl;
    }
};

WApplication *createMyApplication(const WEnvironment& env)
{
    return new MyApp(env);
}

int main(int argc, char **argv)
{
    return WRun(argc, argv, &createMyApplication);
}
