

//  > g++ -o main main.cc -lcrypt -lwthttp -lwt -lboost_signals-mt -lboost_system-mt
//  > ./main --docroot . --http-address 127.0.0.1 --http-port 9090



#include <sstream>

#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WBreak>

using namespace std;
using namespace Wt;

class MyApp : public WApplication
{
public:

    MyApp(const WEnvironment& env)
        : WApplication(env)
    {
      WPushButton* button1 = new WPushButton( "Button 1", root() );
      button1->clicked().connect( this, &MyApp::changePath1 );

      WPushButton* button2 = new WPushButton( "Button 2", root() );
      button2->clicked().connect( this, &MyApp::changePath2 );

      new WBreak(root());
      state_text = new WText("no button pushed yet", root());

      internalPathChanged().connect( this, &MyApp::handlePathChange );
    }

    WText *state_text;

    void changePath1() { 
      std::cerr << "Button1 clicked" << std::endl;
      setInternalPath( "/page1", false );
      state_text->setText("greatest button pushed: button 1");      
    }

    void changePath2() {
      std::cerr << "Button2 clicked" << std::endl;
      setInternalPath( "/page2", false ); 
      state_text->setText("leastest button pushed: button 2");      
    }

    void handlePathChange( std::string path )
    {
      std::cout << "handlePathChange " << path << std::endl;
      stringstream ss;
      ss << "silly user, you manually navigated to: " << path;
      ss << " which is the same as: " << internalPath();
      state_text->setText(ss.str());
    }
};

WApplication *createMyApplication(const WEnvironment& env)
{
  return new MyApp(env);
}

int main(int argc, char **argv)
{
    return WRun(argc, argv, &createMyApplication);
}
