#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <string>

using namespace std;

#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WVBoxLayout>
#include <Wt/WLabel>
#include <Wt/WStackedWidget>
#include <Wt/WMenu>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TSTApplication : public WApplication
{
		WContainerWidget *body;

		void start();

	public:
		TSTApplication(const WEnvironment& env);
};

class TSTMessage : public WContainerWidget
{
	public:
		TSTMessage();
};

class TSTRelatives : public WContainerWidget
{
		void expand();

	public:
		TSTRelatives(const string &);
};

const char *MESSAGE = "meta";

const char *BODY = "body";

TSTMessage::TSTMessage()
{
	WVBoxLayout *vbox = new WVBoxLayout;
	vbox->addWidget(new WText("<pre>" + string(MESSAGE) + "</pre>"));
	vbox->addWidget(new WText("<pre>" + string(BODY) + "</pre>"));
	setLayout(vbox);
}

TSTRelatives::TSTRelatives
(
	const string &who
)
{
	setLayoutSizeAware(true);
	WVBoxLayout *vbox = new WVBoxLayout;
	WPushButton *expand = new WPushButton("Expand " + who);
	expand->clicked().connect(this, &TSTRelatives::expand);
	vbox->addWidget(expand);
	setLayout(vbox);
}

void TSTRelatives::expand()
{
	clear();
	for (int i = 0; i < 3; i++)
	{
		this->addWidget(new WBreak);
		WString num = WString("{1}<hr/>").arg(i);
		this->addWidget(new WText(num));
		this->addWidget(new TSTMessage);
	}
}

void TSTApplication::start()
{
	for (int i = 0; i < 10; i++)
	{
		body->addWidget(new WBreak);
		WString num = WString("{1}<hr/>").arg(i);
		body->addWidget(new WText(num));
		body->addWidget(new TSTMessage);
	}
}

TSTApplication::TSTApplication
(
	const WEnvironment& env
)
: WApplication(env)
{
	WApplication::instance()->setTheme(new WBootstrapTheme);

	WContainerWidget *appcont = new WContainerWidget;
	WStackedWidget *contents = new WStackedWidget;
	WMenu *menu = new WMenu(contents, Wt::Horizontal, appcont);
	menu->addStyleClass("nav-tabs");

	// tab1
	WContainerWidget *cont = new WContainerWidget;
	WVBoxLayout *vbox = new WVBoxLayout;
	body = new WContainerWidget;
	WPushButton *b = new WPushButton("Start");
	b->clicked().connect(this, &TSTApplication::start);
	vbox->addWidget(b);
	vbox->addWidget(body);
	cont->setLayout(vbox);
	menu->addItem("TAB1", cont);

	// tab2
	cont = new WContainerWidget;
	vbox = new WVBoxLayout;
	vbox->addWidget(new WLabel("TODO"));
	cont->setLayout(vbox);
	menu->addItem("TAB2", cont);

	appcont->addWidget(contents);

	root()->addWidget(appcont);
}

WApplication *createApplication(const WEnvironment& env)
{
	return new TSTApplication(env);
}

int main(int argc, char **argv)
{
	return WRun(argc, argv, &createApplication);
}
