#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <string>

using namespace std;

#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WLineEdit>
#include <Wt/WHBoxLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WGroupBox>
#include <Wt/WLabel>
#include <Wt/WDateEdit>
#include <Wt/WStackedWidget>
#include <Wt/WMenu>
#include <Wt/WBootstrapTheme>
#include <Wt/WTabWidget>

using namespace Wt;

class TSTApplication : public WApplication
{
		WContainerWidget *body;

	public:
		TSTApplication(const WEnvironment& env);
};

class TSTConcoction : public WContainerWidget
{
	public:
		TSTConcoction();
};

TSTConcoction::TSTConcoction()
{
	WVBoxLayout *vbox = new WVBoxLayout;

	WGroupBox *gbox = new WGroupBox("A Group Box");
	WTabWidget *tabw = new WTabWidget(gbox);
	tabw->setStyleClass("tabwidget");

	// tab1:
	{
	WContainerWidget *tab = new WContainerWidget;

	WHBoxLayout *hbox = new WHBoxLayout;

	hbox->addWidget(new WLabel("First:"));
	hbox->addWidget(new WLineEdit);
	hbox->addWidget(new WLabel("Second:"));
	hbox->addWidget(new WLineEdit);
	hbox->addWidget(new WLabel("Third:"));
	hbox->addWidget(new WLineEdit);

	tab->setLayout(hbox);

	tabw->addTab(tab, "TAB1",  Wt::WTabWidget::PreLoading);
	}

	// tab2:
	{
	WContainerWidget *tab = new WContainerWidget;

	WHBoxLayout *hbox = new WHBoxLayout;

	hbox->addWidget(new WLabel("Only:"));
	hbox->addWidget(new WLineEdit);

	tab->setLayout(hbox);

	tabw->addTab(tab, "TAB2",  Wt::WTabWidget::PreLoading);
	}

	vbox->addWidget(gbox);

	// towards the bottom
	gbox = new WGroupBox("Below The Lot");
	WHBoxLayout *hbox = new WHBoxLayout;

	hbox->addWidget(new WLabel("Left:"));
	hbox->addWidget(new WDateEdit);
	hbox->addWidget(new WLineEdit);

	hbox->addWidget(new WLabel("Middle:"));
	hbox->addWidget(new WDateEdit);
	hbox->addWidget(new WLineEdit);

	hbox->addWidget(new WLabel("Right:"));
	hbox->addWidget(new WLineEdit);

	gbox->setLayout(hbox);
	vbox->addWidget(gbox);

	setLayout(vbox);
}

TSTApplication::TSTApplication
(
	const WEnvironment& env
)
: WApplication(env)
{
	WApplication::instance()->setTheme(new WBootstrapTheme);

	WContainerWidget *appcont = new WContainerWidget;
	WStackedWidget *contents = new WStackedWidget;
	WMenu *menu = new WMenu(contents, Wt::Horizontal, appcont);
	menu->addStyleClass("nav-tabs");

	// tab1
	WContainerWidget *cont = new WContainerWidget;
	WVBoxLayout *vbox = new WVBoxLayout;

	WHBoxLayout *hbox = new WHBoxLayout;
	WLabel *l = new WLabel("Dummy:");
	hbox->addWidget(l);
	hbox->addWidget(new WLineEdit);
	vbox->addLayout(hbox);

	vbox->addWidget(new TSTConcoction);

	cont->setLayout(vbox);
	menu->addItem("TAB1", cont);

	// tab2
	cont = new WContainerWidget;
	vbox = new WVBoxLayout;
	vbox->addWidget(new WLabel("TODO"));
	cont->setLayout(vbox);
	menu->addItem("TAB2", cont);

	appcont->addWidget(contents);

	root()->addWidget(appcont);
}

WApplication *createApplication(const WEnvironment& env)
{
	return new TSTApplication(env);
}

int main(int argc, char **argv)
{
	return WRun(argc, argv, &createApplication);
}
