#include <boost/date_time/posix_time/posix_time.hpp>
#include <Wt/WBoostAny>

namespace bpt = boost::posix_time;

int main(void)
{
  std::cout << "num fractional digits: "
            << bpt::time_duration::num_fractional_digits() << std::endl;
  {
    bpt::time_duration td(0, 0, 0);
    Wt::WString s = Wt::asString(td, "HH:mm:ss.zzz");
    std::cout << td << " asString is: " << s.toUTF8() << std::endl;
  }
  {
    bpt::time_duration td(0, 0, 0, 0);
    Wt::WString s = Wt::asString(td, "HH:mm:ss.zzz");
    std::cout << td << " asString is: " << s.toUTF8() << std::endl;
  }
  {
    bpt::time_duration td(0, 0, 0, 123);
    Wt::WString s = Wt::asString(td, "HH:mm:ss.zzz");
    std::cout << td << " asString is: " << s.toUTF8() << std::endl;
  }
  {
    bpt::time_duration td(0, 0, 0, 123456);
    Wt::WString s = Wt::asString(td, "HH:mm:ss.zzz");
    std::cout << td << " asString is: " << s.toUTF8() << std::endl;
  }
  {
    bpt::time_duration td(0, 0, 0, 123456789);
    Wt::WString s = Wt::asString(td, "HH:mm:ss.zzz");
    std::cout << td << " asString is: " << s.toUTF8() << std::endl;
  }
  return 0;
}
