/*
 * Copyright (C) 2008 Emweb bvba, Heverlee, Belgium.
 *
 * See the LICENSE file for terms of use.
 */

#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WLineEdit>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WSlider>
#include <Wt/WHBoxLayout>


// c++0x only, for std::bind
// #include <functional>

using namespace Wt;

/*
 * A simple hello world application class which demonstrates how to react
 * to events, read input, and give feed-back.
 */
class HelloApplication : public WApplication
{
public:
  HelloApplication(const WEnvironment& env);
  void ValueChanged();
  void SliderMoving(int value);

private:
  WLineEdit *nameEdit_;
  WText *greeting_;
  WSlider *_slider;
  WText *_textLabel;
  void greet();
};

/*
 * The env argument contains information about the new session, and
 * the initial request. It must be passed to the WApplication
 * constructor so it is typically also an argument for your custom
 * application constructor.
*/
HelloApplication::HelloApplication(const WEnvironment& env)
  : WApplication(env)
{
	setTitle("Hello world");                               // application title

	_textLabel = new Wt::WText("");
	root()->addWidget(_textLabel);

	Wt::WContainerWidget *sliderLayoutWrapper = new Wt::WContainerWidget(root());


	Wt::WHBoxLayout *sliderLayout = new Wt::WHBoxLayout();

	sliderLayoutWrapper->setLayout(sliderLayout);


	//Create the slider and add it to the page
	_slider = new Wt::WSlider(Wt::Horizontal);
	_slider->addStyleClass("slider");
	_slider->setInline(true);
	_slider->setTickPosition(Wt::WSlider::TicksAbove);
	_slider->setTickInterval(10);
	_slider->setMinimum(1910);
	_slider->setMaximum(2010);
	_slider->setValue(1960);
	sliderLayout->addWidget(_slider, 1);
	_slider->valueChanged().connect(this, &HelloApplication::ValueChanged);
	_slider->sliderMoved().connect(this, &HelloApplication::SliderMoving);

}

void HelloApplication::ValueChanged()
{

  float tempValue = (float)_slider->value();
  _textLabel->setText(boost::lexical_cast<std::string>(tempValue));

}

void HelloApplication::SliderMoving(int value)
{
  _textLabel->setText(boost::lexical_cast<std::string>(value));
}

WApplication *createApplication(const WEnvironment& env)
{
  /*
   * You could read information from the environment to decide whether
   * the user has permission to start a new application
   */
  return new HelloApplication(env);
}

int main(int argc, char **argv)
{
  /*
   * Your main method may set up some shared resources, but should then
   * start the server application (FastCGI or httpd) that starts listening
   * for requests, and handles all of the application life cycles.
   *
   * The last argument to WRun specifies the function that will instantiate
   * new application objects. That function is executed when a new user surfs
   * to the Wt application, and after the library has negotiated browser
   * support. The function should return a newly instantiated application
   * object.
   */
  return WRun(argc, argv, &createApplication);
}

