#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WPushButton>
#include <Wt/WLineEdit>

#include <iostream>
#include <boost/thread.hpp>

using namespace Wt;
using namespace boost;
using namespace std;

class ExampleWidget;

class CometTestApplication : public WApplication
{
public:
  CometTestApplication(const WEnvironment& env);
    ExampleWidget *t;
};

class ExampleWidget : public WLineEdit
{
    boost::thread updater;
   
public:
    void startBigWork()
    {
       wApp->enableUpdates(true); // enable server-push temporarily

       updater = boost::thread(boost::bind(&ExampleWidget::doWork, this, WApplication::instance(), text()));
    }

    ExampleWidget()
    {
       keyWentUp().connect(SLOT(this, ExampleWidget::startBigWork));
    }

    void doWork(WApplication *app, const WString s)
    {
      WApplication::UpdateLock uiLock = app->getUpdateLock(); // RAII lock
      cout << endl << s << endl;
       
      setText(s + " " + s);

      cout << endl << text() << endl;

      // if using server push, push now the changes to the client
      app->triggerUpdate();

      app->enableUpdates(false); // disable server-push again
   }
};

CometTestApplication::CometTestApplication(const WEnvironment& env)
  : WApplication(env)
{
    t = new ExampleWidget();
   
    root()->addWidget(t);
}

WApplication *createApplication(const WEnvironment& env)
{
  return new CometTestApplication(env);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}
