#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WTableView>
#include <Wt/WStringListModel>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <boost/algorithm/string.hpp>

using namespace Wt;
static const int MAX_ROWS = 100;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
};

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env)
{
  setTitle("WTableView scrollTo() Issue");

  new WText("Use button to try and drive issue where WTableView displays 'Loading'<br/>"
            "Issue is timing dependent so you may need to press button a few times to retry<br/>",
            root());

  auto tvm1 = new WStringListModel(this);
  for (int i = 0; i < MAX_ROWS; i ++)
    tvm1->addString(boost::lexical_cast<std::string>(i));

  auto tv1 = new WTableView(root());
  tv1->resize(WLength(180), WLength(300));
  tv1->setModel(tvm1);
  tv1->scrollTo(tvm1->index(MAX_ROWS * 8 / 10, 0), WAbstractItemView::PositionAtTop);

  auto pb = new WPushButton("Push to reduce number of entries and scroll", root());
  pb->clicked().connect(std::bind([=] () {
    if (tvm1->rowCount() == MAX_ROWS) {
      tvm1->removeRows(MAX_ROWS - (MAX_ROWS / 5), MAX_ROWS / 5);
      tv1->scrollTo(tvm1->index(10, 0), WAbstractItemView::PositionAtTop);
      pb->setText("push to restart");
    }
    else {
      redirect(environment().deploymentPath());
      quit();
    }
  }));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
