#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WTemplate>

/*
 * A simple hello world application class which demonstrates how to react
 * to events, read input, and give feed-back.
 */
class CustomApplication : public Wt::WApplication
{
	public:
		CustomApplication(const Wt::WEnvironment& env);

	private:
		Wt::WTemplate *_template;
};

/*
 * The env argument contains information about the new session, and
 * the initial request. It must be passed to the WApplication
 * constructor so it is typically also an argument for your custom
 * application constructor.
*/
CustomApplication::CustomApplication(const Wt::WEnvironment& env)
  : Wt::WApplication(env)
{

	_template = new Wt::WTemplate("<a href='#/test-page'>Test Link</a>");
	_template->setInternalPathEncoding(true);

	root()->addWidget(_template);

	setInternalPath("/", true);

}

Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
  return new CustomApplication(env);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}

