#include <Wt/WServer>
#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WCssTheme>
#include <Wt/WBootstrapTheme>
#include "treetestwidget.h"

Wt::WApplication*
createApplication(const Wt::WEnvironment& env)
{
	Wt::WApplication *app = new Wt::WApplication(env);
	const std::string *theme = env.getParameter("theme");
	if (theme)
	{
		app->setTheme(new Wt::WCssTheme(*theme));
	}
	else
	{
		app->setTheme(new Wt::WBootstrapTheme(app));
	}
	app->root()->addWidget(new TreeTestWidget);

	return app;
}

int main(int argc, char** argv)
{
	try
	{
		Wt::WServer server(argv[0]);
		server.setServerConfiguration(argc, argv, WTHTTP_CONFIGURATION);
		server.addEntryPoint(Wt::Application, createApplication);
		if (server.start())
		{
			Wt::WServer::waitForShutdown();
			server.stop();
		}
	}
	catch (Wt::WServer::Exception& e)
	{
		return 1;
	}

	return 0;
}
