#ifndef TREEMODEL_H
#define TREEMODEL_H

#include <QHash>
#include <Wt/WString>
#include <Wt/WAbstractItemModel>

class DomainObject;
struct DomainObjectNode;

class TreeModel: public Wt::WAbstractItemModel
{
public:
	explicit TreeModel(Wt::WObject *parent = 0);
	void addObjects(QList<DomainObject*> objects);
	void removeObjects(QList<DomainObject*> objects);
	void removeObject(DomainObject* object);
	Wt::WModelIndex getDomainObjectIndex(DomainObject *object) const;
	DomainObject* getDomainObject(const Wt::WModelIndex &index) const;

	Wt::WModelIndex index(int row, int column, const Wt::WModelIndex &parent) const;
	Wt::WModelIndex parent(const Wt::WModelIndex &index = Wt::WModelIndex()) const;

	int rowCount(const Wt::WModelIndex &parent = Wt::WModelIndex()) const;
	int columnCount(const Wt::WModelIndex &parent = Wt::WModelIndex()) const;
	boost::any data(const Wt::WModelIndex &index, int role) const;
	boost::any headerData(int section, Wt::Orientation orientation, int role) const;

private:
	DomainObjectNode* nodeFromIndex(const Wt::WModelIndex& index) const;
	Wt::WModelIndex searchDomainObject(DomainObject *object, Wt::WModelIndex searchRootIndex) const;

	DomainObjectNode* rootNode;///< корневой узел
	QHash<QString, DomainObjectNode*> nodeHash;///< хэш: ID объекта -> узел в дереве
};

class DomainObject
{
public:
	DomainObject(QString name, QString ident, QString parentId): name(name), ident(ident), parentId(parentId){}
	QString getObjectName() const {return name;}
	QString getObjectId() const {return ident;}
	QString getParentObjectId() {return parentId;}

private:
	QString name;
	QString ident;
	QString parentId;
};

struct DomainObjectNode
{
	DomainObjectNode(): object(0), parentNode(0) {}
	~DomainObjectNode() { qDeleteAll(childNodes);}

	DomainObject* object;///< объект предметной области
	DomainObjectNode* parentNode;///< родительский узел
	QList<DomainObjectNode*> childNodes;///< дочерние узлы
};

#endif // TREEMODEL_H
