#include "treemodel.h"

#include "treetestwidget.h"

using namespace Wt;

TreeTestWidget::TreeTestWidget(WContainerWidget *parent): WContainerWidget(parent)
{
	model = new TreeModel;
	tree = new WTreeView;
	tree->setModel(model);
	tree->setSelectionMode(SingleSelection);
	tree->setSelectionBehavior(SelectRows);

	removeButton = new WPushButton("Remove selected node");
	removeButton->clicked().connect(this, &TreeTestWidget::onRemoveButtonClicked);

	addWidget(tree);
	addWidget(removeButton);

	fillModelWithData();
}

void
TreeTestWidget::onRemoveButtonClicked()
{
	WModelIndexSet selected = tree->selectedIndexes();
	if (!selected.empty())
	{
		WModelIndex index = *selected.begin();
		if (index.isValid())
		{
			model->removeObject(model->getDomainObject(index));
		}
	}
}

void
TreeTestWidget::fillModelWithData()
{
	int nextId = 0;
	DomainObject* groupA = new DomainObject("Group A", QString::number(++nextId), "");

	DomainObject* anzi = new DomainObject("Anzhi", QString::number(++nextId), groupA->getObjectId());
	DomainObject* etoo = new DomainObject("Etoo", QString::number(++nextId), anzi->getObjectId());
	DomainObject* kokorin = new DomainObject("Kokorin", QString::number(++nextId), anzi->getObjectId());
	DomainObject* spam = new DomainObject("Spartak", QString::number(++nextId), groupA->getObjectId());
	DomainObject* kuban = new DomainObject("Kuban", QString::number(++nextId), groupA->getObjectId());

	DomainObject* groupB = new DomainObject("Group B", QString::number(++nextId), "");
	DomainObject* pahtakor = new DomainObject("Pahtakor", QString::number(++nextId), groupB->getObjectId());
	DomainObject* bayern = new DomainObject("Bayern", QString::number(++nextId), groupB->getObjectId());
	DomainObject* zulte = new DomainObject("Zultevaregem", QString::number(++nextId), groupB->getObjectId());

	QList<DomainObject*> objects;
	objects.append(groupA);
	objects.append(anzi);
	objects.append(etoo);
	objects.append(kokorin);
	objects.append(spam);
	objects.append(kuban);
	objects.append(groupB);
	objects.append(pahtakor);
	objects.append(bayern);
	objects.append(zulte);

	model->addObjects(objects);
}
