#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WTabWidget>
#include <Wt/WVBoxLayout>
#include <Wt/WText>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
};

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env)
{
  setTitle("Layout with display none");

  auto root_layout = new WVBoxLayout();
  root()->setLayout(root_layout);

  auto tab2_container = new WContainerWidget();
  auto tab2_layout = new WVBoxLayout();
  auto tab2_subtab = new WTabWidget();
  tab2_subtab->addTab(new WText("subtab 1"), "subtab1");
  tab2_container->setLayout(tab2_layout);
  tab2_layout->addWidget(tab2_subtab);
  tab2_subtab->hide();

  auto tab_widget = new WTabWidget();
  tab_widget->addTab(new WText("tab1 text"), "tab1");
  tab_widget->addTab(tab2_container, "tab2 (click for error)");

  root_layout->addWidget(tab_widget);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
