#include<Wt/Dbo/Dbo>
#include<Wt/Dbo/backend/Sqlite3>


class testClass
{
public:
	std::string name;
	
	Wt::Dbo::collection<Wt::Dbo::ptr<testClass> >testRelationActive;
	Wt::Dbo::collection<Wt::Dbo::ptr<testClass> >testRelationPassive;
	
	template<class Action>
	void persist(Action&a)
	{
		Wt::Dbo::field(a,name,"name");
		
		Wt::Dbo::hasMany(a,testRelationActive,Wt::Dbo::ManyToMany,"testRelation","testRelationActive");
		Wt::Dbo::hasMany(a,testRelationPassive,Wt::Dbo::ManyToMany,"testRelation","testRelationPassive");
	}
};


int main(int argc,char**argv)
{
	Wt::Dbo::backend::Sqlite3 dbBackend(":memory:");
	Wt::Dbo::Session dbSession;
	Wt::Dbo::ptr<testClass>ptr1;
	Wt::Dbo::ptr<testClass>ptr2;
	
	dbSession.setConnection(dbBackend);
	dbSession.mapClass<testClass>("testClass");
	dbSession.createTables();
	
	
	Wt::Dbo::Transaction tr(dbSession);
	ptr1=dbSession.add(new testClass);
	ptr2=dbSession.add(new testClass);
	
	ptr1.modify()->name=std::string("object1");
	ptr2.modify()->name=std::string("object2");
	
	ptr1.modify()->testRelationActive.insert(ptr2);
	
	dbSession.flush();
	
	ptr1.modify()->testRelationActive.clear();
	
	dbSession.flush();
	
	return 0;
}
