#include<iostream>
#include<Wt/Dbo/Dbo>
#include<Wt/Dbo/backend/Sqlite3>


class testClass;
class testClass2;

class testClass
{
public:
	std::string name;
	
	Wt::Dbo::collection<Wt::Dbo::ptr<testClass2> >testRelation;
	
	template<class Action>
	void persist(Action&a)
	{
		Wt::Dbo::field(a,name,"name");
		
		Wt::Dbo::hasMany(a,testRelation,Wt::Dbo::ManyToMany,"testRelation");
	}
};

class testClass2
{
public:
	std::string name;
	
	Wt::Dbo::collection<Wt::Dbo::ptr<testClass> >testRelation;
	
	template<class Action>
	void persist(Action&a)
	{
		Wt::Dbo::field(a,name,"name");
		
		Wt::Dbo::hasMany(a,testRelation,Wt::Dbo::ManyToMany,"testRelation");
	}
};


int main(int argc,char**argv)
{
	Wt::Dbo::backend::Sqlite3 dbBackend(":memory:");
	Wt::Dbo::Session dbSession;
	Wt::Dbo::ptr<testClass>ptr1;
	Wt::Dbo::ptr<testClass2>ptr2;
	
	dbSession.setConnection(dbBackend);
	dbSession.mapClass<testClass>("testClass");
	dbSession.mapClass<testClass2>("testClass2");
	dbSession.createTables();
	
	
	Wt::Dbo::Transaction tr(dbSession);
	ptr1=dbSession.add(new testClass);
	ptr2=dbSession.add(new testClass2);
	
	ptr1.modify()->name=std::string("object1");
	ptr2.modify()->name=std::string("object2");
	
	ptr1.modify()->testRelation.insert(ptr2);
	
	dbSession.flush();

	ptr1.modify()->testRelation.clear();
	
	dbSession.flush();
	
	return 0;
}
