#include <Wt/WApplication>
#include <Wt/WContainerWidget>
#include <Wt/WGLWidget>
#include <Wt/WEnvironment>
#include <Wt/WServer>
#include <Wt/WText>
#include <Wt/WImage>

using namespace std;
using namespace Wt;


/**********************GraphicsPanel class**********************************/
class GraphicsPanel : public Wt::WGLWidget
{
public:
	// Constructor(s)
	GraphicsPanel(Wt::WContainerWidget *root = nullptr);

	// Destructor(s)
	~GraphicsPanel();

protected:
	void initializeGL();
	void paintGL();
	void resizeGL(int width, int height);
private:

};

GraphicsPanel::GraphicsPanel(WContainerWidget *root) :
WGLWidget(root)
{
	
}

// Destructor(s)
GraphicsPanel::~GraphicsPanel()
{

}


void GraphicsPanel::initializeGL()
{	
	depthFunc(LESS);
	enable(DEPTH_TEST);
	clearStencil(0);
	clearColor(0.0, 1.0, 0.0, 1.0);
}

void GraphicsPanel::paintGL()
{
	clear(COLOR_BUFFER_BIT | DEPTH_BUFFER_BIT);
}

void GraphicsPanel::resizeGL(int  width, int height)
{
	if (height == 0)
	{
		height = 1;
	}

	viewport(0, 0, width, height);		// Reset The Current Viewport	
}

class GLApp : public Wt::WApplication
{
public:
	GLApp(const Wt::WEnvironment& env, bool embedded);
private:
	Wt::WText *greeting_;
	GraphicsPanel* _graphicsPanel;
};
/********************************************************************************/

/***********************************GLApp****************************************/
GLApp::GLApp(const Wt::WEnvironment& env, bool embedded)
	: WApplication(env)
{
	Wt::WContainerWidget *top;

	setTitle("GLApp with Wt - Alpha");

	if (!embedded)
	{
		/*
		* In Application mode, we have the root() is a container
		* corresponding to the entire browser window
		*/
		top = root();
	}
	else
	{
		/*
		* In WidgetSet mode, we create and bind containers to existing
		* divs in the web page. In this example, we create a single div
		* whose DOM id was passed as a request argument.
		*/
		top = new Wt::WContainerWidget();
		const std::string *div = env.getParameter("div");
		if (div)
		{
			setJavaScriptClass(*div);
			bindWidget(top, *div);
		}
		else
		{
			std::cerr << "Missing: parameter: 'div'" << std::endl;
			return;
		}
	}

	if (!embedded)
	{
		new Wt::WText
			("<p><emph>Note: you can also run this application "
			"from within <a href=\"test_wt_gl_widgetset.html\">a web page</a>.</emph></p>",
			root());
	}

	/*
	* Everything else is business as usual.
	*/
	//top->setInline(false);

	_graphicsPanel = new GraphicsPanel(top);
	_graphicsPanel->resize(500, 300);
	_graphicsPanel->setAlternativeContent(new WImage("nowebgl.png"));
	_graphicsPanel->setInline(false);


	greeting_ = new Wt::WText(top);
	greeting_->setText("Hello there, from GLApp");

}
/********************************************************************************/

Wt::WApplication *createApplication(const Wt::WEnvironment& env)
{
	return new GLApp(env, false);
}

Wt::WApplication *createWidgetSet(const Wt::WEnvironment& env)
{
	return new GLApp(env, true);
}

int main(int argc, char **argv)
{
	Wt::WServer server(argv[0]);

	// Use default server configuration: command line arguments and the
	// wthttpd configuration file.
	server.setServerConfiguration(argc, argv, WTHTTP_CONFIGURATION);

	// Application entry points. Each entry point binds an URL with an
	// application (with a callback function used to bootstrap a new
	// application).

	// The following is the default entry point. It configures a
	// standalone Wt application at the deploy path configured in the
	// server configuration.
	server.addEntryPoint(Wt::Application, createApplication);

	// The following adds an entry point for a widget set. A widget set
	// must be loaded as a JavaScript from an HTML page.
	server.addEntryPoint(Wt::WidgetSet, createWidgetSet, "/GLApp.js");

	// Start the server (in the background if there is threading support)
	// and wait for a shutdown signal (e.g. Ctrl C, SIGKILL)
	if (server.start())
	{
		Wt::WServer::waitForShutdown();

		// Cleanly terminate all sessions
		server.stop();
	}
}