#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WStringListModel>
#include <Wt/WTableView>
#include <Wt/WText>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
  ~TestApplication() { delete theme(); }
};

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env)
{
  setTitle("Tooltip Test");

  setTheme(new WBootstrapTheme());

  auto slm = new WStringListModel(this);

  for (int i = 0; i < 20; ++i) {
    std::string row_s = boost::lexical_cast<std::string>(i);
    std::string cell_text = "row " + row_s;
    std::string tooltip_text = "A tooltip for row " + row_s;
    slm->addString(cell_text);
    slm->setData(slm->index(i, 0), tooltip_text, ToolTipRole);
    slm->setFlags(i, ItemIsXHTMLText);
  }

  auto tv = new WTableView(root());
  tv->setModel(slm);
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
