#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WDialog>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WTable>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
  ~TestApplication() { delete theme(); }
private:
  int next_dialog_ {0};
  const int POSITION_ROWS = 4;
  const int POSITION_COLS = 5;
};

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env)
{
  setTitle("Test WDialog Escape");
  setTheme(new WBootstrapTheme());

  new WText("<h4>Press button to open a few dialogs. Re-order by clicking dialog titles. "
      "Pressing escape key should close dialogs based on their stack order.</h4>", root());
  auto openDialogButton = new WPushButton("Open WDialog", root());
  auto positionTable = new WTable(root());
  for (int row=0; row <  POSITION_ROWS; row++) {
    for (int col=0; col < POSITION_COLS; col++) {
      positionTable->elementAt(row, col)->resize(80, 80);
    }
  }

  openDialogButton->clicked().connect(std::bind([=] {
    int row = (next_dialog_  * 3 / POSITION_COLS) % POSITION_ROWS;
    int col = next_dialog_ * 3 % POSITION_COLS;
    next_dialog_ += 1;

    auto dialog = new WDialog("Click to raise");
    dialog->setModal(false);
    dialog->setResizable(true);
    dialog->setClosable(true);
    dialog->rejectWhenEscapePressed(true);
    dialog->positionAt(positionTable->elementAt(row, col));
    new WText(WString("<h1>Dialog {1}</h1>").arg(next_dialog_),
      dialog->contents());
    dialog->setCanReceiveFocus(true);
  }));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
