/*
 * Modified version of Koen's hidden.cc, which was attached to #2604
 */

#include <Wt/WApplication>
#include <Wt/WStandardItemModel>
#include <Wt/WStandardItem>
#include <Wt/WContainerWidget>
#include <Wt/WPushButton>
#include <Wt/WTableView>

using namespace Wt;

unsigned cols = 5;
unsigned rows = 5;

class TestApp : public WApplication
{
public:
  void createRow(std::vector<WStandardItem *>& row, int size,
		 const std::string& s) {

    row.clear();

    for (int i = 0; i < size; ++i) {
      WStandardItem *t
	= new WStandardItem(s + " c" + boost::lexical_cast<std::string>(i));

      row.push_back(t);
    }
  }

  WStandardItemModel *createModel() {
    model_ = new WStandardItemModel(0, cols, this);

    for (unsigned i = 0; i < cols; ++i)
      model_->setHeaderData(i, Horizontal,
			    "col " + boost::lexical_cast<std::string>(i));

    std::vector<WStandardItem *> row;

    for (unsigned i = 0; i < rows; ++i) {
      createRow(row, cols, "Item "+ boost::lexical_cast<std::string>(i));
      model_->appendRow(row);
    }

    return model_;
  }

  TestApp(const WEnvironment& env) : WApplication(env)
  {
    WTableView *tv = new WTableView(root());
    tv->setMaximumSize(WLength::Auto, 500);
    tv->setModel(createModel());

    WPushButton *add = new WPushButton("add", root());
    add->clicked().connect(this, &TestApp::add);
    tv->hide();

    tv_ = tv;
    
    /* add first batch prior to render */
    this->add();
  }

  void add() {
    tv_->show();

    std::vector<WStandardItem *> row;

    for (unsigned i = 0; i < 5; ++i) {
      createRow(row, cols, "Item "+ boost::lexical_cast<std::string>(i));
      model_->appendRow(row);
    }
  }

private:
  WStandardItemModel *model_;
  WTableView *tv_;
};

WApplication *createApplication(const WEnvironment& env)
{
  TestApp *app = new TestApp(env);

  return app;
}

int main(int argc, char *argv[])
{
  return WRun(argc, argv, &createApplication);
}
