#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WContainerWidget>
#include <Wt/WDialog>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WTable>
#include <Wt/WCssTheme>
#include <Wt/WBootstrapTheme>

using namespace Wt;

class TestApplication : public WApplication
{
public:
  TestApplication(const WEnvironment& env);
  ~TestApplication() { delete theme_css_; }
private:
  int next_dialog_ {0};
  const int POSITION_ROWS = 4;
  const int POSITION_COLS = 5;
  WBootstrapTheme theme_;
  WCssTheme *theme_css_;
};

TestApplication::TestApplication(const WEnvironment& env) : WApplication(env), theme_css_(0)
{
  setTitle("Test WDialog Escape");
  const std::string *themePtr = env.getParameter("theme");
  std::string theme_s;
  if (!themePtr)
    theme_s = "bootstrap3";
  else
    theme_s = *themePtr;

  if (theme_s == "bootstrap2") {
    theme_.setVersion(WBootstrapTheme::Version2);
    setTheme(&theme_);
  }
  else if (theme_s == "bootstrap3") {
    theme_.setVersion(WBootstrapTheme::Version3);
    setTheme(&theme_);
  }
  else {
    theme_css_ = new WCssTheme(theme_s);
    setTheme(theme_css_);
  }

  new WText("<h4>Try different themes using theme parameter. Move and resize windows. "
      "Try using an initial window around the size of the grid and expanding it after "
      "opening a few dialogs.</h4>", root());
  auto openDialogButton = new WPushButton("Open WDialog", root());
  auto positionTable = new WTable(root());
  for (int row=0; row <  POSITION_ROWS; row++) {
    for (int col=0; col < POSITION_COLS; col++) {
      positionTable->elementAt(row, col)->resize(80, 80);
      WCssDecorationStyle(ds);
      ds.setBackgroundColor(WColor(11*(row*POSITION_COLS+col),
            11*(row*POSITION_COLS+col), 11*(row*POSITION_COLS+col)));
      positionTable->elementAt(row, col)->setDecorationStyle(ds);
    }
  }

  openDialogButton->clicked().connect(std::bind([=] {
    int row = (next_dialog_  * 3 / POSITION_COLS) % POSITION_ROWS;
    int col = next_dialog_ * 3 % POSITION_COLS;
    next_dialog_ += 1;

    auto dialog = new WDialog("Click to raise");
    dialog->setModal(false);
    dialog->setResizable(true);
    dialog->setClosable(true);
    dialog->rejectWhenEscapePressed(true);
    dialog->positionAt(positionTable->elementAt(row, col));
    new WText(WString("<h1>Dialog {1}</h1>").arg(next_dialog_),
      dialog->contents());
    dialog->setCanReceiveFocus(true);
  }));
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, [](const WEnvironment& env) {return new TestApplication(env);});
}
