#include	<Wt/WApplication>
#include	<Wt/WLabel>
#include	<Wt/WBreak>
#include	<Wt/WContainerWidget>
#include	<Wt/WPopupMenu>
#include	<Wt/WPoint>
#include	<Wt/WPaintedWidget>
#include	<Wt/WPainter>

#include	<boost/test/unit_test.hpp>
#include	<boost/lexical_cast.hpp>

namespace
{
	class Painted 
		: public Wt::WPaintedWidget
	{
		int myI;
		int x;
	public:
		Painted( int i, Wt::WContainerWidget* parent = 0 )
			: Wt::WPaintedWidget( parent )
			, myI( i )
			, x( 0 )
		{
			mouseWentUp().connect( SLOT( this, Painted::MouseWentUp ) );
			mouseWentDown().connect( SLOT( this, Painted::MouseWentDown ) );
			mouseMoved().connect( SLOT( this, Painted::MouseMoved ) );
		}
		virtual void paintEvent( Wt::WPaintDevice* paintDevice )
		{
			Wt::WPainter painter( paintDevice );
			painter.drawText( painter.window(), Wt::AlignCenter | Wt::AlignMiddle, boost::lexical_cast< std::string >( myI + x++ ) );
			painter.restore();
		}
		void MouseWentDown( const Wt::WMouseEvent& e )
		{
		}
		void MouseMoved( const Wt::WMouseEvent& e )
		{
		}
		void MouseWentUp( const Wt::WMouseEvent& e )
		{
			update();
		}

	};	

	class TestToolTip 
		: public Wt::WApplication
	{
	public:
		TestToolTip( const Wt::WEnvironment& env )
			: Wt::WApplication( env )
		{
			setCssTheme( "polished" );
		    root()->setAttributeValue( "oncontextmenu", "event.cancelBubble = true; event.returnValue = false; return false;" );
			root()->mouseWentUp().connect( SLOT( this, TestToolTip::MouseWentUp ) );
			root()->mouseWentDown().connect( SLOT( this, TestToolTip::MouseWentDown ) );
			root()->mouseMoved().connect( SLOT( this, TestToolTip::MouseMoved ) );

			for( int i = 0; i < 20; ++i )
			{
				auto x = new Painted( i, root() );
				x->resize( 100, 20 );
				x->setToolTip( GetTooltipText(), Wt::XHTMLText);
				x->doubleClicked().connect( SLOT( this, TestToolTip::DoubleClicked ) );
				new Wt::WBreak( root() );
			}

		}
		void MouseWentDown( const Wt::WMouseEvent& e )
		{
		}
		void MouseMoved( const Wt::WMouseEvent& e )
		{
		}
		void MouseWentUp( const Wt::WMouseEvent& e )
		{
		}
		void DoubleClicked( const Wt::WMouseEvent& e )
		{
			Wt::WPopupMenu* popup = new Wt::WPopupMenu;
			for( int i = 0; i < 20; ++i )
				popup->addItem( boost::lexical_cast< std::string >( i ) + " test" );
			popup->popup( e );
		}
		std::string GetTooltipText()
		{
			return 
				"<b>Title of tooltip</b>"
				"<br/>"
				"<br/>"
				"Some text text text text text text text text text text text text text text text<br/>"
				;
		}
	};
}
