#!/bin/sh

CC="g++ -std=c++0x -DNDEBUG -Wall"
WTINCLUDE=/home/kai/wt/wt-3.3.4-rc1/install/include
WTLIBS=/home/kai/wt/wt-3.3.4-rc1/install/lib
WTWITHQTINCLUDE=/home/kai/wt/wt-3.3.4-rc1/examples/wtwithqt/lib
QTINCLUDE=/usr/include/qt4
QTCOREINCLUDE=/usr/include/qt4/QtCore 

echo "Creating DispatchThread_moc.cpp"
moc -o DispatchThread_moc.cpp $WTWITHQTINCLUDE/DispatchThread.h

echo "Compiling DispatchThread.C"
`$CC -I$WTINCLUDE -I$WTWITHQTINCLUDE -I$QTINCLUDE -I$QTCOREINCLUDE -c $WTWITHQTINCLUDE/DispatchThread.C`

echo "Compiling WQApplication.C"
`$CC -I$WTINCLUDE -I$WTWITHQTINCLUDE -I$QTINCLUDE -I$QTCOREINCLUDE -c $WTWITHQTINCLUDE/WQApplication.C`

echo "Compiling DispatchThread_moc.cpp"
`$CC -I$WTINCLUDE -I$WTWITHQTINCLUDE -I$QTINCLUDE -I$QTCOREINCLUDE -c DispatchThread_moc.cpp`

echo "Compiling DemoModel.cpp"
`$CC -I$WTINCLUDE -I$WTWITHQTINCLUDE -I$QTINCLUDE -I$QTCOREINCLUDE -c DemoModel.cpp`

echo "Compiling DemoApplication.cpp"
`$CC -I$WTINCLUDE -I$WTWITHQTINCLUDE -I$QTINCLUDE -I$QTCOREINCLUDE -c DemoApplication.cpp`

echo "Compiling main.cpp"
`$CC -I$WTINCLUDE -I$WTWITHQTINCLUDE -I$QTINCLUDE -I$QTCOREINCLUDE -c main.cpp`

echo "Linking binary WtThreadingProblem"
g++ main.o DemoApplication.o DemoModel.o WQApplication.o DispatchThread.o DispatchThread_moc.o -L$WTLIBS -lwt -lboost_thread -lboost_signals -lQtCore -lwthttp -o WtThreadingProblem

#./WtThreadingProblem --docroot=/home/kai/wt/wt-3.3.4-rc1/install/share/Wt --http-address=0.0.0.0 --http-port=8080
