#include "DemoApplication.h"
#include "DemoModel.h"
#include <Wt/WContainerWidget>
#include <Wt/WText>
#include <Wt/WTableView>

namespace WB
{
		Wt::WApplication* DemoApplication::Create(const Wt::WEnvironment& env)
		{
				const auto pApp = new DemoApplication(env);
				return pApp;
		}

		DemoApplication::DemoApplication(const Wt::WEnvironment& env) :
		Wt::WQApplication(env)
		{
				// as our model is updated from its private thread we need to enable server side updates within
				// our application
				enableUpdates();
		}

		void DemoApplication::create()
		{
				// our model needs to know our session id
				const auto pModel = new DemoModel(sessionId());

				// now create our table view and do some setup work
				const auto pTableView = new Wt::WTableView;
				pTableView->setModel(pModel);

				pTableView->setSortingEnabled(false);
				pTableView->setAlternatingRowColors(true);
				pTableView->setRowHeight(28);
				pTableView->setHeaderHeight(28);
				pTableView->setSelectionMode(Wt::ExtendedSelection);
				pTableView->setEditTriggers(Wt::WAbstractItemView::NoEditTrigger);
				pTableView->setColumnWidth(0, Wt::WLength(64));
				pTableView->setColumnWidth(1, Wt::WLength(512));
				pTableView->resize(800, 400);

				root()->addWidget(pTableView);
		}

		void DemoApplication::destroy()
		{

		}
}
