
#include <Wt/WApplication>
#include <Wt/WEnvironment>
#include <Wt/WMenu>
#include <Wt/WMenuItem>
#include <Wt/WBreak>
#include <Wt/WText>

#include <boost/bind.hpp>

using namespace Wt;

void printItem(WMenuItem *item, WText *msg) {
    msg->setText(item->text());
}

Wt::WApplication* createApp(const Wt::WEnvironment& env) {
    WApplication* app = new WApplication(env);

    app->setCssTheme("polished");
    app->useStyleSheet( "everywidget.css");

    WContainerWidget *w(app->root());
    WMenu *mainMenu = new WMenu(Vertical,w);
    mainMenu->setStyleClass("menu");

    WMenu *subMenu = new WMenu();
    subMenu->setStyleClass("menu submenu");
    WMenu *subMenu2 = new WMenu();
    subMenu2->setStyleClass("menu submenu");

    mainMenu->addItem("item",0);
    mainMenu->addMenu("sub menu ",subMenu);

    subMenu->addItem("item",0);
    subMenu->addMenu("sub menu2 ",subMenu2);

    subMenu2->addItem("item 1",0);
    subMenu2->addItem("item 2",0);

    new WBreak(w);
    new WText("last selected item: ", w);

    WText *msg = new WText(w);

    mainMenu->itemSelected().connect(boost::bind(&printItem,_1,msg));
    subMenu->itemSelected().connect(boost::bind(&printItem,_1,msg));
    subMenu2->itemSelected().connect(boost::bind(&printItem,_1,msg));

    return app;
}


int main(int argc, char** argv) {
    return WRun(argc,argv,&createApp);
}

